% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.operators.r
\name{any2T}
\alias{any2T}
\alias{any2A}
\alias{any2Afr}
\title{Convert filter quantities.}
\usage{
any2T(x, action = "add", clean = FALSE)

any2A(x, action = "add", clean = FALSE)

any2Afr(x, action = "add", clean = FALSE)
}
\arguments{
\item{x}{an filter_spct or a filter_mspct object.}

\item{action}{character Allowed values "replace" and "add".}

\item{clean}{logical replace off-boundary values before conversion}
}
\value{
A copy of \code{x} with the columns for the different quantities
  added or replaced. If \code{action = "replace"}, in all cases, the
  additional columns are removed, even if no column needs to be added.
}
\description{
Functions that convert or add related physical quantities to
\code{filter_spct} or  \code{object_spct} objects. transmittance (fraction)
into absorptance (fraction).
}
\details{
These functions are dispatchers for \code{\link{A2T}},
  \code{\link{Afr2T}}, \code{\link{T2A}}, and \code{\link{T2Afr}}. The
  dispatch is based on the names of the variables stored in \code{x}. They
  do not support in-place modification of \code{x}.
}
\examples{
any2Afr(Ler_leaf.spct)
any2T(Ler_leaf.spct)
any2T(polyester.spct)

}
\seealso{
Other quantity conversion functions: 
\code{\link{A2T}()},
\code{\link{Afr2T}()},
\code{\link{T2Afr}()},
\code{\link{T2A}()},
\code{\link{as_quantum}()},
\code{\link{e2qmol_multipliers}()},
\code{\link{e2quantum_multipliers}()},
\code{\link{e2q}()},
\code{\link{q2e}()}
}
\concept{quantity conversion functions}
