% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.operators.r
\name{e2q}
\alias{e2q}
\alias{e2q.default}
\alias{e2q.source_spct}
\alias{e2q.response_spct}
\alias{e2q.source_mspct}
\alias{e2q.response_mspct}
\title{Convert energy-based quantities into photon-based quantities.}
\usage{
e2q(x, action, byref, ...)

\method{e2q}{default}(x, action = "add", byref = FALSE, ...)

\method{e2q}{source_spct}(x, action = "add", byref = FALSE, ...)

\method{e2q}{response_spct}(x, action = "add", byref = FALSE, ...)

\method{e2q}{source_mspct}(x, action = "add", byref = FALSE, ..., .parallel = FALSE, .paropts = NULL)

\method{e2q}{response_mspct}(x, action = "add", byref = FALSE, ..., .parallel = FALSE, .paropts = NULL)
}
\arguments{
\item{x}{an R object.}

\item{action}{a character string, one of "add", "replace", "add.raw" or
"replace.raw".}

\item{byref}{logical indicating if a new object will be created by reference
or a new object returned.}

\item{...}{not used in current version.}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\description{
Conversion methods for spectral energy irradiance into spectral photon
irradiance and for spectral energy response into spectral photon
response.
}
\details{
The converted spectral values are added to or replace the existing
  spectral values depending on the argument passed to parameter
  \code{action}. Addition is currently not supported for normalized spectra.
  If the spectrum has been normalized with a recent version of package
  'photobiology' the spectrum will be renormalized after conversion using the
  same arguments as previously. \code{"add.raw"} and \code{"replace.raw"}
  prevent the re-normalization, are included for completeness and as a way
  of restoring previous behaviour.
}
\section{Methods (by class)}{
\itemize{
\item \code{e2q(default)}: Default method

\item \code{e2q(source_spct)}: Method for spectral irradiance

\item \code{e2q(response_spct)}: Method for spectral responsiveness

\item \code{e2q(source_mspct)}: Method for collections of (light) source spectra

\item \code{e2q(response_mspct)}: Method for collections of response spectra

}}
\seealso{
Other quantity conversion functions: 
\code{\link{A2T}()},
\code{\link{Afr2T}()},
\code{\link{T2Afr}()},
\code{\link{T2A}()},
\code{\link{any2T}()},
\code{\link{as_quantum}()},
\code{\link{e2qmol_multipliers}()},
\code{\link{e2quantum_multipliers}()},
\code{\link{q2e}()}
}
\concept{quantity conversion functions}
