% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.classes.r
\name{range_check_Tfr}
\alias{range_check_Tfr}
\alias{range_check_Afr}
\alias{range_check_Rfr}
\alias{range_check_A}
\alias{range_check_cps}
\alias{range_check_s.irrad}
\alias{range_check_irrad.mult}
\title{Internal utility range-check functions}
\usage{
range_check_Tfr(x, strict.range)

range_check_Afr(x, strict.range)

range_check_Rfr(x, strict.range)

range_check_A(x, strict.range)

range_check_cps(x, cps.cols, strict.range)

range_check_s.irrad(x, strict.range)

range_check_irrad.mult(x, strict.range)
}
\arguments{
\item{x}{Spectral object to check.}

\item{strict.range}{logical indicating the stringency of the test.}
}
\description{
Functions used in the different \code{check_spct()} methods.
}
\details{
If \code{strict.range} is \code{NULL} or \code{NA} the failed
  test is output using \code{message()}, if \code{FALSE}, using
  \code{warning()} and if \code{TRUE}, using \code{stop()}. Currently
  the test condition and the message text is the same in all cases.

  The test is failed only if more than 1/250 spectral values are off-range,
  except for \code{cps_spct} objects where 1/100 negative spectral values
  are tolerated. The test for off-range values includes a small tolerance
  to avoid failure in cases of loss of numerical precision.

  The criteria are empirical (almost arbitrary) and may be adjusted in
  future versions. The difficulty is that measured spectral data can be
  noisy even when valid and error-free.
}
\keyword{internal}
