% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.tails.R
\name{trim_tails}
\alias{trim_tails}
\title{Trim (or expand) head and/or tail}
\usage{
trim_tails(x, y, low.limit = min(x), high.limit = max(x),
  use.hinges = TRUE, fill = NULL)
}
\arguments{
\item{x}{numeric array}

\item{y}{numeric array}

\item{low.limit}{smallest x-value to be kept (defaults to smallest
x-value in input)}

\item{high.limit}{largest x-value to be kept (defaults to largets
x-value in input)}

\item{use.hinges}{logical, if TRUE (the default)}

\item{fill}{if fill==NULL then tails are deleted, otherwise tails of y
are filled with the value of fill}
}
\value{
a data.frame with variables \code{x} and \code{y}
}
\description{
Trimming of tails of a spectrum based on wavelength limits, interpolating the
values at the boundaries.Trimming is needed for example to remove short
wavelength noise when the measured spectrum extends beyond the known emission
spectrum of the measured light source. Occasionally one may want also to
expand the wavelength range.
}
\note{
When expanding an spectrum, if fill==NULL, then expansion is not
  performed with a warning.
}
\examples{
head(sun.data)
head(with(sun.data,
     trim_tails(w.length, s.e.irrad, low.limit=300)))
head(with(sun.data,
     trim_tails(w.length, s.e.irrad, low.limit=300, fill=NULL)))

}
\seealso{
Other trim functions: \code{\link{clip_wl}},
  \code{\link{trim_spct}}, \code{\link{trim_waveband}},
  \code{\link{trim_wl}}
}
