% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.new.r
\name{as.object_spct}
\alias{as.object_spct}
\alias{as.object_spct.default}
\title{Coerce to a spectrum}
\usage{
as.object_spct(x, ...)

\method{as.object_spct}{default}(x, Tfr.type = c("total", "internal"),
  Rfr.type = c("total", "specular"),
  strict.range = getOption("photobiology.strict.range", default = FALSE), ...)
}
\arguments{
\item{x}{an R object}

\item{...}{other arguments passed to "set" functions}

\item{Tfr.type}{a character string, either "total" or "internal"}

\item{Rfr.type}{a character string, either "total" or "specular"}

\item{strict.range}{logical Flag indicating whether off-range values result
in an error instead of a warning}
}
\value{
A copy of \code{x} converted into a \code{object_spct} object.
}
\description{
Return a copy of an R object with its class set to a given type of spectrum.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: 
}}

\seealso{
\code{\link{setGenericSpct}}

Other constructors of spectral objects: \code{\link{as.calibration_spct}},
  \code{\link{as.chroma_spct}}, \code{\link{as.cps_spct}},
  \code{\link{as.filter_spct}},
  \code{\link{as.generic_spct}}, \code{\link{as.raw_spct}},
  \code{\link{as.reflector_spct}},
  \code{\link{as.response_spct}},
  \code{\link{as.source_spct}}, \code{\link{source_spct}}
}
