% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waveband.class.r
\name{spread}
\alias{spread}
\alias{wl_expanse}
\alias{expanse}
\alias{expanse.default}
\alias{expanse.numeric}
\alias{expanse.waveband}
\alias{expanse.generic_spct}
\alias{expanse.generic_mspct}
\title{Expanse}
\usage{
spread(x, ...)

wl_expanse(x, ...)

expanse(x, ...)

\method{expanse}{default}(x, ...)

\method{expanse}{numeric}(x, ...)

\method{expanse}{waveband}(x, ...)

\method{expanse}{generic_spct}(x, ...)

\method{expanse}{generic_mspct}(x, ..., idx = !is.null(names(x)))
}
\arguments{
\item{x}{an R object}

\item{...}{not used in current version}

\item{idx}{logical whether to add a column with the names of the elements of spct}
}
\value{
A numeric value equal to max(x) - min(x). In the case of spectral
  objects wavelength difference in nm. For any other R object, according to
  available definitions of \code{\link{min}} and \code{\link{max}}.
}
\description{
A function that returns the expanse (max(x) - min(x)) for R objects.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method for generic function

\item \code{numeric}: Method for "numeric"

\item \code{waveband}: Method for "waveband"

\item \code{generic_spct}: Method for "generic_spct"

\item \code{generic_mspct}: Method for "generic_mspct" objects.
}}

\examples{
expanse(10:20)
expanse(sun.spct)
wl_expanse(sun.spct)

expanse(sun.spct)

}
