% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/head-tail.R
\name{head_tail}
\alias{head_tail}
\alias{head_tail.default}
\alias{head_tail.data.frame}
\alias{head_tail.matrix}
\alias{head_tail.function}
\alias{head_tail.table}
\alias{head_tail.ftable}
\title{Return the First and Last Part of an Object}
\usage{
head_tail(x, n = 3L, ...)

\method{head_tail}{default}(x, n = 3L, ...)

\method{head_tail}{data.frame}(x, n = 3L, ...)

\method{head_tail}{matrix}(x, n = 3L, ...)

\method{head_tail}{function}(x, n = 6L, ...)

\method{head_tail}{table}(x, n = 6L, ...)

\method{head_tail}{ftable}(x, n = 6L, ...)
}
\arguments{
\item{x}{an R object.}

\item{n}{integer. If positive, \code{n} rows or members in the
returned object are copied from each of "head" and "tail" of \code{x}.
If negative, all except \code{n} elements of \code{x} from each of "head"
and "tail" are returned.}

\item{...}{arguments to be passed to or from other methods.}
}
\value{
An object (usually) like \code{x} but smaller, except when
 \code{n = 0}. For \code{ftable} objects \code{x}, a transformed
 \code{format(x)}.
}
\description{
Returns the first and last "parts" (rows or members) of a spectrum,
dataframe, vector, function, table or ftable. In other words, the combined
output from methods \code{head} and \code{tail}.
}
\details{
The value returned by \code{head_tail()} is equivalent to row
  binding the the values returned by \code{head()} and \code{tail()},
  although not implemented in this way. The same specializations as defined
  in package 'utils' for \code{head()} and \code{tail()} have been
  implemented.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method

\item \code{data.frame}: Specialization for \code{data.frame} objects

\item \code{matrix}: Specialization for \code{matrix}

\item \code{function}: Specialization for \code{function}

\item \code{table}: Specialization for \code{table}

\item \code{ftable}: Specialization for \code{ftable}
}}

\note{
For some types of input, like functions, the output may be confusing,
 however, we have opted for consistency with existing functions. The code
 is in part a revision of that of head() and tail() from package 'utils'. I
 have been missing this method especially when checking spectral data, as
 both ends are of interest.

\code{head_tail()} methods for function, table and ftable classes, are
  wrappers for head() method.
}
\examples{

head_tail(letters)
head_tail(letters, n = -6L)
head_tail(freeny.x, n = 10L)
head_tail(freeny.y)

head_tail(stats::ftable(Titanic))

}
\seealso{
\code{\link[utils]{head}}, and compare the examples and the values
 returned to the examples below.
}
