% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d2.spectrum.r
\name{D2_spectrum}
\alias{D2_spectrum}
\title{Calculate deuterim lamp output spectrum from fitted constants}
\usage{
D2_spectrum(w.length, k = D2.UV653, fill = NULL)
}
\arguments{
\item{w.length}{numeric vector of wavelengths (nm) for output}

\item{k}{a numeric vector with n constants for the polynomial}

\item{fill}{if NA, no extrapolation is done, and NA is returned for
wavelengths outside the range of the input. If NULL then the tails are
deleted. If 0 then the tails are set to zero, etc. NULL is default.}
}
\value{
a dataframe with four numeric vectors with wavelength values
  (w.length), energy and photon irradiance (s.e.irrad, s.q.irrad) depending
  on the argument passed to unit.out (s.irrad).
}
\description{
Calculate values by means of a nth degree polynomial from
user-supplied constants (for example from a lamp calibartion certificate).
}
\note{
This is function is valid for wavelengths in the range 180 nm to 495
  nm, for wavelengths outside this range NAs are returned.
}
\examples{
D2_spectrum(200)
D2_spectrum(170:220)

}

