% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fel.spectrum.r
\name{FEL_spectrum}
\alias{FEL_spectrum}
\title{Incandescent "FEL" lamp emission spectrum}
\usage{
FEL_spectrum(w.length, k = FEL, fill = NA)
}
\arguments{
\item{w.length}{numeric vector of wavelengths (nm) for output}

\item{k}{a numeric vector with n constants for the polynomial}

\item{fill}{if NA, no extrapolation is done, and NA is returned for
wavelengths outside the range of the input. If NULL then the tails are
deleted. If 0 then the tails are set to zero, etc. NULL is default.}
}
\value{
a dataframe with four numeric vectors with wavelength values
  (w.length), energy and photon irradiance (s.e.irrad, s.q.irrad) depending
  on the argument passed to unit.out (s.irrad).
}
\description{
Calculate values by means of a nth degree polynomial from
user-supplied constants (for example from a lamp calibration certificate).
}
\note{
This is function is valid for wavelengths in the range 180 nm to 495
  nm, for wavelengths outside this range NAs are returned.
}
\examples{
FEL_spectrum(200)
FEL_spectrum(170:220)
}

