#' Filter spectra data for commercial grenhouse films from XL Horticulture
#'
#' Datasets containing the wavelengths at a 1 nm interval and
#' tabulated values spectral transmittance for different films used as
#' greenhouse cladding.
#'
#' The variables are as follows:
#'
#' \itemize{
#'   \item w.length (nm)
#'   \item Tfr (fraction)
#' }
#'
#' \url{https://www.xlhorticulture.co.uk/}
#'
#' Instrument used: Shimadzu UV-2501 PC (Shimadzu Suzhou Instruments Manufacturing
#' Co. Ltd, China) equiped with an integrating sphere.
#'
#' @note Idependent measurement of a single sample, not a specification.
#'
#' @docType data
#' @keywords datasets
#'
#' @format A vector of character strings.
#'
#' @examples
#' xl_horticulture_filters
#'
"xl_horticulture_filters"
