% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-wasatch-csv.r
\name{read_wasatch_csv}
\alias{read_wasatch_csv}
\title{Read File Saved by Wasatch's Enlighten.}
\usage{
read_wasatch_csv(
  file,
  date = NULL,
  geocode = NULL,
  label = NULL,
  tz = NULL,
  locale = readr::default_locale(),
  s.qty = NULL,
  extra.cols = "keep",
  scale.factor = 1,
  simplify = TRUE,
  ...
)
}
\arguments{
\item{file}{character}

\item{date}{a \code{POSIXct} object to use to set the \code{"when.measured"}
attribute. If \code{NULL}, the default, the date and time are extracted from the
file header.}

\item{geocode}{A data frame with columns \code{lon} and \code{lat} used to
set attribute \code{"where.measured"}.}

\item{label}{character string, but if \code{NULL} the value of \code{file} is
used, and if \code{NA} the "what.measured" attribute is not set.}

\item{tz}{character Time zone is by default that of the machine's locale.}

\item{locale}{The locale controls defaults that vary from place to place. The
default locale is US-centric (like R), but you can use
\code{\link[readr]{locale}} to create your own locale that controls things
like the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{s.qty}{character, possibly named. The name of the quantity using the
conventions accepted used in package 'photobiology' that is to be imported
from column "Processed" from the file.}

\item{extra.cols}{character What to do non-processed data columns if present 
in file. One of \code{"keep"}, \code{"drop.pixel"}, \code{"drop"} or 
\code{"split"}.}

\item{scale.factor}{numeric vector of length 1, or length equal to the number
of rows (= detector pixels). Numeric multiplier applied to returned
spectral values.}

\item{simplify}{logical If TRUE, single spectra are returned as individual 
spectra instead of collections of length one.}

\item{...}{additional arguments passed to the constructor of the spectrum
object.}
}
\value{
An object of a class derived from \code{generic_spct} such as
  \code{raw_spct} or \code{filter_spct}. \code{generic_spct} is derived from
  tibble and data frame.
}
\description{
Read wavelength and spectral data from the data section of a file as
output by Enlighten importing them into R. Parse the header of a file to
extract the acquisition time, instrument name and serial number, as well
additional metadata related to the instrument and its settings. Function
\code{read_wasatch_csv()} only accepts "column oriented" CSV files.
}
\details{
Enlighten's column-wise CSV files contain at least two columns,
  Wavelength and Processed. In the header the Technique used is recorded.
  Additional data columns can be present. Column Pixel contains the pixel
  index in the array as integers. Columns Raw, Dark and Reference contain
  detector counts data. Technique is used to guess the type of spectrum
  stored in the column named Processed, which can be detector counts or
  derived values. By default the data are read into a single spectrum object
  and all columns retained, but only the data in Processed are interpreted as
  spectral data corresponding to the class of the object. If passed
  \code{extra.cols = "drop"}, only Wavelength and Processed are copied to the
  returned object, while if passed \code{extra.cols = "drop.pixel"} only the
  contents of column Pixel are discarded. If passed \code{extra.cols =
  "split"} all columns containing spectral data are each read into a separate
  spectrum, these are collected and a "generic_mspct" object containing them
  returned. \code{extra.cols} can be a named vector of mappings, of length at
  least one but possibly longer. If longer a "generic_mspct" is returned,
  otherwise a spectrum object as inferred from the name each column is mapped
  to.
}
\note{
Enlighten, the free software from Wasatch Photonics can save spectra in
  a variety of additional formats: different types of CSV files, plain text
  and JSON. Plain text files contain no metadata or even column headers and
  if the need arises can be read with R function \code{read.table()}. JSON
  files contain the most detailed metadata.
}
\section{Acknowledgements}{

We thank Ruud Niesen from Photon Mission 
(\url{https://www.photonmission.com/}) for organizing the loan of the
spectrometer used to produce the various files needed for the development of 
this function.
}

\examples{

 file.name <- 
   system.file("extdata", "enlighten-wasatch-scope.csv",
               package = "photobiologyInOut", mustWork = TRUE)
              
 wasatch.raw.spct <- 
   read_wasatch_csv(file = file.name)
 summary(wasatch.raw.spct)

 wasatch.raw.spct <- 
   read_wasatch_csv(file = file.name, s.qty = "counts")
 summary(wasatch.raw.spct)

 wasatch.raw.spct <- 
   read_wasatch_csv(file = file.name, s.qty = c(Processed = "counts"))
 summary(wasatch.raw.spct)

 wasatch.raw.spct <- 
   read_wasatch_csv(file = file.name, extra.cols = "drop")
 summary(wasatch.raw.spct)

}
\references{
\url{https://wasatchphotonics.com/}
  \url{https://wasatchphotonics.com/product-category/software/}
}
