#' Spectral data for LEDs array supplied by Led Engin
#' 
#' Datasets containing the wavelengths and tabulated values spectral emittance 
#' for light emitting diodes (LEDs) and arrays from Led Engin (USA). Data are
#' normalized to one at the wavelength of maximum emission.
#' 
#' The variables are as follows:
#' \itemize{
#'   \item w.length (nm)  
#'   \item s.e.irrad (W m-2 nm-1)
#' }
#' 
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#' 
#' @examples 
#' led_engin
#' # leds.mspct[led_engin]
#' 
#' @note
#' Led Engin is a supplier of power LEDs of high efficiency.
#' \url{http://www.ledengin.com/}
#'   
"led_engin"
