#' Spectral data for LEDs of different colors
#' 
#' Names of datasets containing the wavelengths and tabulated values spectral emittance 
#' for the light emitting diodes (LEDs) from various suppliers. 
#' 
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#' 
#' @aliases amber_leds blue_leds green_leds red_leds white_leds cyan_leds violet_leds multichannel_leds
#' 
#' @examples 
#' uv_leds
#' violet_leds
#' blue_leds
#' cyan_leds
#' green_leds
#' amber_leds
#' red_leds
#' white_leds
#' multichannel_leds
#' 
#' # select LEDs emitting in the amber, yellow, orange region
#' leds.mspct[amber_leds]
#' 
#' @seealso \code{\link{leds.mspct}}
#' 
"uv_leds"
