% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/macam.r
\docType{data}
\name{macam}
\alias{macam}
\alias{philips.tl12.mc}
\alias{qpanel.uva340}
\alias{qpanel.uvb313}
\title{Spectra acquired with Macam SR-9010-PC}
\format{A vector of character strings.}
\usage{
macam
}
\description{
A collection of lamp emission spectra measured with a Macam
  SR-9010-PC spectroradiometer.
}
\details{
\code{macam} is a character vector with indexes to members of 
  \code{\link{lamps.mspct}} with spectral emission data for Q-Panel UVB-313
  and UVA-340 40W fluorescent tubes, and for Philips TL12 40W fluorescent
  tubes.

  The variables in each member spectrum are as follows: \itemize{ \item
  w.length (nm) \item s.e.irrad (relative energy based units) }
}
\note{
Instrument used: Macam SR-9010-PC scanning double monochromator
  spectroradiometer with a cosine corrected input optics. Recently
  calibrated. The lamps were probably driven by a high frequency electronic
  ballast. Measured between 1996 to 1998.
}
\examples{
lamps.mspct[macam]
lamps.mspct[["qpanel.uvb313"]]
lamps.mspct$qpanel.uvb313

}
\references{
Aphalo, P J, R Tegelberg, and R Julkunen-Tiitto. 1999. The
  Modulated UV-B Irradiation System at the University of Joensuu.” Biotronics
  28: 109–120.
  \url{http://ci.nii.ac.jp/naid/110006175827/en}.
}
\keyword{datasets}

