% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structured.R
\name{structured}
\alias{structured}
\alias{has_structured_support}
\title{Structured geocoding}
\usage{
structured(
  .data,
  limit = 3,
  lang = "en",
  bbox = NULL,
  osm_tag = NULL,
  layer = NULL,
  locbias = NULL,
  locbias_scale = NULL,
  zoom = NULL,
  progress = interactive()
)

has_structured_support()
}
\arguments{
\item{.data}{Dataframe or list containing structured information on a place
to geocode. Can contain the columns \code{street}, \code{housenumber},
\code{postcode}, \code{city}, \code{district}, \code{county}, \code{state},
and \code{countrycode}. At least one of these columns must be present in the
dataframe. Note that countries must be passed as ISO-2 country codes.}

\item{limit}{Number of results to return. Defaults to 3.}

\item{lang}{Language of the results.}

\item{bbox}{Any object that can be parsed by \code{\link[sf]{st_bbox}}.
Results must lie within this bbox.}

\item{osm_tag}{Character string giving an
\href{https://wiki.openstreetmap.org/wiki/Tags}{OSM tag} to filter the
results by. See details.}

\item{layer}{Character string giving a layer to filter the results by.
Can be one of \code{"house"}, \code{"street"}, \code{"locality"},
\code{"district"}, \code{"city"}, \code{"county"}, \code{"state"},
\code{"country"}, or \code{"other"}.}

\item{locbias}{Numeric vector of length 2 or any object that can be coerced
to a length-2 numeric vector (e.g. a list or \code{sfg} object). Specifies a
location bias for geocoding in the format \code{c(lon, lat)}. Geocoding
results are biased towards this point. The radius of the bias is controlled
through \code{zoom} and the weight of place prominence through
\code{location_bias_scale}.}

\item{locbias_scale}{Numeric vector specifying the importance of prominence
in \code{locbias}. A higher prominence scale gives more weight to important
places. Defaults to 0.2.}

\item{zoom}{Numeric specifying the radius for which the \code{locbias} is
effective. Corresponds to the zoom level in OpenStreetMap. The exact relation
to \code{locbias} is \eqn{0.25\text{ km} \cdot 2^{(18 - \text{zoom})}}.
Defaults to 16.}

\item{progress}{If \code{TRUE}, shows a progress bar for longer queries.}
}
\value{
An sf dataframe or tibble containing the following columns:

\itemize{
 \item{\code{idx}: Internal ID specifying the index of the \code{texts}
 parameter.}
 \item{\code{osm_type}: Type of OSM element, one of N (node), W (way),
 R (relation), or P (polygon).}
 \item{\code{osm_id}: OpenStreetMap ID of the matched element.}
 \item{\code{country}: Country of the matched place.}
 \item{\code{city}: City of the matched place.}
 \item{\code{osm_key}: OpenStreetMap key.}
 \item{\code{countrycode}: ISO2 country code.}
 \item{\code{housenumber}: House number, if applicable.}
 \item{\code{postcode}: Post code, if applicable.}
 \item{\code{locality}: Locality, if applicable.}
 \item{\code{street}: Street, if applicable.}
 \item{\code{district}: District name, if applicable.}
 \item{\code{osm_value}: OpenStreetMap tag value.}
 \item{\code{name}: Place name.}
 \item{\code{type}: Layer type as described for the \code{layer} parameter.}
 \item{\code{extent}: Boundary box of the match.}
}
}
\description{
Geocode a set of place information such as street, house number, or
post code. Structured geocoding is generally more accurate but requires
more information than \link[=geocode]{unstructured geocoding}.

Note that structured geocoding must be specifically enabled when building a
Nominatim database. It is generally not available on komoot's public API and
on pre-built search indices through \code{\link{download_searchindex}}. See
\code{vignette("nominatim-import", package = "photon")} for details. You can
use the helper function \code{has_structured_support()} to check if the
current API supports structured geocoding.
}
\details{
Filtering by OpenStreetMap tags follows a distinct syntax explained on
\url{https://github.com/komoot/photon}. In particular:

\itemize{
 \item{Include places with tag: \code{key:value}}
 \item{Exclude places with tag: \code{!key:value}}
 \item{Include places with tag key: \code{key}}
 \item{Include places with tag value: \code{:value}}
 \item{Exclude places with tag key: \code{!key}}
 \item{Exclude places with tag value: \code{:!value}}
}
}
\examples{
\dontrun{
# structured() requires an OpenSearch instance with structured support
# the following code will not work off the shelf
# refer to vignette("nominatim-import") for details
dir <- file.path(tempdir(), "photon")
photon <- new_photon(dir, opensearch = TRUE)
photon$import(password = "psql_password", structured = TRUE)
photon$start()

# check if structured() is supported
has_structured_support()

# structured() works on dataframes containing structurized data
place_data <- data.frame(
  housenumber = c(NA, "77C", NA),
  street = c("Falealilli Cross Island Road", "Main Beach Road", "Le Mafa Pass Road"),
  state = c("Tuamasaga", "Tuamasaga", "Atua")
)
structured(place_data, limit = 1)

# countries must be specified as iso2 country codes
structured(data.frame(countrycode = "ws"))

# traditional parameters from geocode() can also be used but are much more niche
structured(data.frame(city = "Apia"), layer = "house") # matches nothing

# structured geocoding can discern small differences in places
safune <- data.frame(
  city = c("Safune", "Safune"),
  state = c("Gaga'ifomauga", "Tuamasaga")
)
structured(safune, limit = 1)
}
}
