% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_phyloregions.R
\name{plot_evoldistinct}
\alias{plot_evoldistinct}
\alias{plot.phyloregion}
\alias{plot_NMDS}
\alias{text_NMDS}
\title{Visualize biogeographic patterns}
\usage{
plot_evoldistinct(
  x,
  palette = "YlOrBr",
  pos = "bottomleft",
  key_label = "",
  legend = TRUE,
  leg = 5,
  lwd = 15,
  ...
)

\method{plot}{phyloregion}(x, shp = NULL, palette = "YlOrBr", ...)

plot_NMDS(x, ...)

text_NMDS(x, ...)
}
\arguments{
\item{x}{an object of class phyloregion from \code{phyloregion}}

\item{palette}{name of the palette to generate colors from.
The name is matched to the list of available color palettes from
the \code{hcl.colors} function in the \code{grDevices} package.}

\item{pos}{location to position the legend such as \dQuote{bottomright},
\dQuote{bottomleft}, \dQuote{topleft}, and \dQuote{topright}.}

\item{key_label}{label for the color key}

\item{legend}{logical indicating whether to add a legend to the map.}

\item{leg}{parameter of the color key.}

\item{lwd}{parameter of the color key.}

\item{\dots}{arguments passed among methods.}

\item{shp}{a polygon shapefile of grid cells.}
}
\value{
No return value, called for plotting.
}
\description{
Visualize biogeographic patterns
}
\examples{
data(africa)
tree <- africa$phylo
x <- africa$comm

subphy <- match_phylo_comm(tree, x)$phy
submat <- match_phylo_comm(tree, x)$com

pbc <- phylobeta(submat, subphy)
y <- phyloregion(pbc[[1]], shp=africa$polys)

plot_NMDS(y, cex=6)
text_NMDS(y, cex=2)
plot(y, cex=1, palette="NMDS")
plot(y, cex=1)
plot_evoldistinct(y)
}
