%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Do not modify this file since it was automatically generated from:
% 
%  ./PhyloSimSource.R
% 
% by the Rdoc compiler part of the R.oo package.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

 \name{GeneralInsertor}
\docType{class}
\alias{GeneralInsertor}


 \title{The GeneralInsertor class}

 \description{

	This is a class implementing a process generating insertion events.
	The rate of each event is calculated as the product of the general rate of the process
       and the "rate.multiplier" site-process specific parameter.
	The simulation code calls the \code{Perform} method on the selected insertion event objects,
	which call their insertion event handler to perform the insertion.

	The insert lengths are proposed by the function stored in the \code{proposeBy}
	virtual field. The function must have the following arguments:
	process (the insertion process object).

	The insertion events are accepted or rejected by the function stored in the \code{acceptBy} virtual field.
	The function must have the following arguments: process (the insertion process object), sequence (the target sequence object),
	window (a vector of positions affecting acceptance).
	The probability of accepting an insertion is calculated as the product of the site-process-specific
	"insertion.tolerance" parameters of the sites neighboring the insertion.
	The number of sites considered is determined by the \code{acceptWin} virtual field.

	The insert is generated by the \code{generateInsert} method by calling the function stored in the \code{generateBy} virtual field.
	The default generator function truncates/duplicates the sequence object stored in the \code{templateSeq} virtual field to get a sequence
	having the sampled length. After constructing the Sequence object, it  calls the \code{sampleStates.Sequence} method on the resulting object.
	That means that if we start with a template sequence which has NA states, but has a substitution process attached, then the resulting sequence
       will be different every time.

	Before inserting the sequence returned by \code{generateInsert}, the handler function will pass the object through the function stored in the
	\code{insertHook} virtual field. This allows to perform arbitrary modifications on the inserted Sequence object.

	The sequence is inserted randomly on the left or the right of the target position.

	Package:   \cr
\bold{Class GeneralInsertor}\cr

\code{\link[R.oo]{Object}}\cr
\code{~~|}\cr
\code{~~+--}\code{\link{PSRoot}}\cr
\code{~~~~~~~|}\cr
\code{~~~~~~~+--}\code{\link{Process}}\cr
\code{~~~~~~~~~~~~|}\cr
\code{~~~~~~~~~~~~+--}\code{\link{GeneralInDel}}\cr
\code{~~~~~~~~~~~~~~~~~|}\cr
\code{~~~~~~~~~~~~~~~~~+--}\code{GeneralInsertor}\cr

\bold{Directly known subclasses:}\cr
\link{BrownianInsertor}, \link{ContinuousInsertor}, \link{DiscreteInsertor}\cr

public static class \bold{GeneralInsertor}\cr
extends \link{GeneralInDel}\cr


 }

 \usage{GeneralInsertor(name="Anonymous", rate=NA, propose.by=NA, accept.by=NA, template.seq=NA, insert.hook=NA, accept.win=NA, ...)}

 \arguments{
 	\item{name}{The name of the object.}
	\item{rate}{The general rate of the object (no default).}
       \item{propose.by}{A function used to propose events (no default).}
       \item{accept.by}{A function used to accept/reject events (no default).}
	\item{template.seq}{A Sequence object used as a template for generating insertions (no default).}
	\item{insert.hook}{A function object, see \code{setInsertHook} (no default).}
	\item{accept.win}{A window of sites affecting the acceptance of insert events.}
 	\item{...}{Additional arguments.}
	}

 \section{Fields and Methods}{
 	\bold{Methods:}\cr
\tabular{rll}{
 \tab \code{checkConsistency} \tab  -\cr
 \tab \code{generateInsert} \tab  -\cr
 \tab \code{getAcceptWin} \tab  -\cr
 \tab \code{getEventsAtSite} \tab  -\cr
 \tab \code{getGenerateBy} \tab  -\cr
 \tab \code{getInsertHook} \tab  -\cr
 \tab \code{getTemplateSeq} \tab  -\cr
 \tab \code{is} \tab  -\cr
 \tab \code{setAcceptWin} \tab  -\cr
 \tab \code{setGenerateBy} \tab  -\cr
 \tab \code{setInsertHook} \tab  -\cr
 \tab \code{setTemplateSeq} \tab  -\cr
 \tab \code{summary} \tab  -\cr
}


 \bold{Methods inherited from GeneralInDel}:\cr
checkConsistency, getAcceptBy, getProposeBy, getRate, hasUndefinedRate, is, proposeLength, setAcceptBy, setProposeBy, setRate, summary

 \bold{Methods inherited from Process}:\cr
as.character, checkConsistency, clone, getAlphabet, getEventsAtSite, getId, getName, getParameterAtSite, getSiteSpecificParamIds, getSiteSpecificParamList, getWriteProtected, hasSiteSpecificParameter, hasUndefinedRate, is, ==, !=, setAlphabet, setId, setName, setParameterAtSite, setSiteSpecificParamIds, setSiteSpecificParamList, setWriteProtected, summary

 \bold{Methods inherited from PSRoot}:\cr
checkConsistency, clone, enableVirtual, getComments, getMethodsList, globalConsistencyCheck, intersect.list, is.na, is, ll, my.all.equal, plot, setComments, setMethodsList, summary, virtualAssignmentForbidden

 \bold{Methods inherited from Object}:\cr
as.character, attachLocally, attach, clearCache, clone, detach, equals, extend, finalize, gc, getEnvironment, getFields, getInstantiationTime, getStaticInstance, hasField, hashCode, ll, load, [[<-, [[, $<-, $, objectSize, print, registerFinalizer, save

 }

 \examples{
	# create a GeneralInsertor object
	i<-GeneralInsertor(
		name="GIN",
		rate=1,
		propose.by=function(process){4}, 			# fixed insert length
		acceptBy=function(process,sequence,window){TRUE},	# always accept insertions
		template.seq=NucleotideSequence(string="A"),		# a boring template sequence
		insert.hook=function(seq){ return(seq)},		# a boring insert hook
		accept.win=2						# 4 sites affecting acceptance
	)
	i
	# check if object inherits from GeneralInsertor
	is.GeneralInsertor(i)
	# get object summary
	summary(i)
	# set/get general rate
	i$rate<-0.5
	i$rate
	# set/get name
	i$name<-"Ins"
	i$name
	# set/get proposeBy
	# sample insertion length between 1 and 10
	i$proposeBy<-function(process){sample(1:10,1)}
	i$proposeBy
	# set/get acceptBy
	# reject half of the insertions
	i$acceptBy<-function(process, sequence, window){ sample(c(TRUE,FALSE), 1) }
	i$acceptBy
	# get generateBy
	i$generateBy
	# set/get acceptWin
	i$acceptWin<-1;
	# set/get insert hook
	i$insertHook<-function(seq, target.seq, event.pos, insert.pos){ attachProcess(seq, GTR() );seq} # attach a substitution process
	i$insertHook
	# set/get template sequence
	i$templateSeq<-NucleotideSequence(length=5, processes=list(list(JC69()))) # length: 5, states: NA
	i$templateSeq
	# generate an insert sequence
	generateInsert(i)
	# create a sequence object and attach the process i
	s<-NucleotideSequence(string="AAAAA",processes=list(list(i)))
       # set rate multiplier
       setRateMultipliers(s,i,2)
       # get the list of active events from site 2
       events<-getEventsAtSite(i,s$sites[[2]])
       events
       # set postition for event
       e<-events[[1]]
       e$.position<-2
       # print sequence
       s
       # perform event
       Perform(e)
       # check sequence again
       s
 }

 \author{Botond Sipos}

 \seealso{
 	GeneralInDel DiscreteInsertor ContinuousInsertor BrownianInsertor
 }
