% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deadspace.R
\name{deadspace_equipment_ml}
\alias{deadspace_equipment_ml}
\title{Calculate equipment deadspace in ventilator breathing circuit}
\usage{
deadspace_equipment_ml(humidifier = c("adult", "infant", "none"),
  elbow = TRUE, flexible = c("none", "compressed", "extended"),
  min = 0)
}
\arguments{
\item{humidifier}{Single value, if \code{TRUE}, the default, then we assume
the adult humidifier. If \code{humidifier} is set to the character string
\code{"adult"}, the results is the same as for \code{TRUE}. Alternatively,
\code{"infant"} refers to the lower volume, higher resistance device.}

\item{elbow}{Single logical value, default is \code{TRUE}}

\item{flexible}{Single logical value or character string. If \code{FALSE},
the default, no additional flexible tubing is added. If \code{TRUE}, the
volume of typical extended flexible tubing is added. If \code{"compressed"}
or \code{"extended"} are given, the volume of flexible tubing in the given
state is used.}

\item{min}{numeric, giving the minimum number of obligatory milliliters of
deadspace. The default is zero to allow calculation of additional airway
elements.}
}
\description{
There are minor brand variations between these airway devices. For the
purposes of rough physiologic calculations, this function gives values based
on real, widely-used equipment.
}
\examples{
deadspace_equipment_ml()
deadspace_equipment_ml(humidifier = FALSE)
deadspace_equipment_ml(humidifier = "infant", elbow = TRUE)
deadspace_equipment_ml(flexible = "extended", elbow = FALSE)
deadspace_equipment_ml(flexible = "extended", elbow = TRUE)
}
\seealso{
\code{\link{deadspace_things_ml}}
}
