% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oldFunctions.R
\name{sem.aic}
\alias{sem.aic}
\title{sem.aic}
\usage{
sem.aic(modelList, data, corr.errors = NULL, add.vars = NULL,
  grouping.vars = NULL, grouping.fun = mean, adjust.p = FALSE,
  basis.set = NULL, pvalues.df = NULL, model.control = NULL,
  .progressBar = TRUE)
}
\arguments{
\item{modelList}{a \code{list} of regressions representing the structural equation model}

\item{data}{a \code{data.frame} used to construct the structured equations}

\item{corr.errors}{a vector of variables with correlated errors (separated by "~~")}

\item{add.vars}{a vector of additional variables whose independence claims should be 
evaluated, but which do not appear in the model list}

\item{grouping.vars}{an optional variable that represents the levels of data aggregation 
for a multi-level dataset}

\item{grouping.fun}{a function defining how variables are aggregated in \code{grouping.vars}. 
Default is \code{mean}}

\item{adjust.p}{whether p-values degrees of freedom should be adjusted. Default is \code{FALSE}}

\item{basis.set}{provide an optional basis set}

\item{pvalues.df}{an optional \code{data.frame} corresponding to p-values for independence claims}

\item{model.control}{a \code{list} of model control arguments to be passed to d-sep models}

\item{.progressBar}{enable optional text progress bar. Default is \code{TRUE}}
}
\value{
Returns a \code{data.frame} where the first entry is the AIC score, and the second is 
the AICc score, and the third is the likelihood degrees of freedom (K)
}
\description{
AIC for piecewiseSEM (old)
}
\details{
This function calculates AIC and AICc (corrected for small sample sizes) values for a piecewise structural 
equation model (SEM).

For linear mixed effects models, p-values can be adjusted to accommodate the full model degrees of freedom 
using the argument \code{p.adjust = TRUE}. For more information, see Shipley 2013.
}
