% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piggyback.R
\docType{package}
\name{piggyback-package}
\alias{piggyback}
\alias{piggyback-package}
\title{piggyback: Managing Larger Data on a GitHub Repository}
\description{
Because larger (> 50 MB) data files cannot easily be committed to git,
a different approach is required to manage data associated with an analysis in a
GitHub repository.  This package provides a simple work-around by allowing larger
(up to 2 GB) data files to piggyback on a repository as assets attached to individual
GitHub releases.  These files are not handled by git in any way, but instead are
uploaded, downloaded, or edited directly by calls through the GitHub API. These
data files can be versioned manually by creating different releases.  This approach
works equally well with public or private repositories.  Data can be uploaded
and downloaded programmatically from scripts. No authentication is required to
download data from public repositories.
}
\details{
It has two main modes or workflows:
\itemize{
\item \code{\link[=pb_upload]{pb_upload()}} / \code{\link[=pb_download]{pb_download()}}:  Upload and download individual files to/from
the desired release of the specified repository
\item \code{\link[=pb_track]{pb_track()}}: Use a \code{git-lfs} style tracking of specific
file types
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/ropensci/piggyback}
  \item Report bugs at \url{https://github.com/ropensci/piggyback/issues}
}

}
\author{
\strong{Maintainer}: Carl Boettiger \email{cboettig@gmail.com} (0000-0002-1642-628X) [copyright holder]

Other contributors:
\itemize{
  \item Mark Padgham (0000-0003-2172-5265) [contributor]
}

}
