% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinyin.R
\name{file2py}
\alias{file2py}
\title{Convert entire files into Pinyin}
\usage{
file2py(folder = "py", backup = TRUE, method = c("quanpin", "tone", "toneless"), 
    sep = " ", nonezh_replace = NULL, only_first_letter = FALSE, multi = FALSE, 
    encoding = "UTF-8")
}
\arguments{
\item{folder}{character. The folder in which the files are to be converted.}

\item{backup}{logical. Whether the original files should be saved as backups.}

\item{method}{character. The value can be:
\itemize{
\item 'quanpin', for the standard form of pinyin (tones above letters),
\item 'tone', for tones expressed with numbers,
\item 'toneless', without tones
}}

\item{sep}{character. Seperation between the converted pinyin.}

\item{nonezh_replace}{NULL or character. Define how to convert non-Chinese characters in mychar. NULL means 'let it be'.}

\item{only_first_letter}{logical. Wheter only the first letter in pinyin.}

\item{multi}{logical. Whether display multiple pronounciations of a Chinese character or only the first pronounciation.}

\item{encoding}{character. The encoding of the input files. 'UTF-8' by default.}
}
\value{
files converted to Pinyin.
}
\description{
Convert entire files into Pinyin
}
\examples{
mydir <- paste0(tempdir(), "/py")
dir.create(mydir)
file.create(paste0(mydir, "/test.txt"))
writeLines(text = "test\\n", paste0(mydir, "/test.txt"))
file2py(mydir)
}
