% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b31gacl.R
\name{b31gacl}
\alias{b31gacl}
\title{ASME B31G. Allowable corrosion length in pipe}
\usage{
b31gacl(dep, maop, d, wth, depth, l)
}
\arguments{
\item{dep}{design pressure of the pipe, [\emph{PSI}]. Type: \code{\link{assert_double}}.}

\item{maop}{maximum allowable operating pressure - \emph{MAOP}, [\emph{PSI}].
Type: \code{\link{assert_double}}.}

\item{d}{nominal outside diameter of the pipe, [\emph{inch}]. Type: \code{\link{assert_double}}.}

\item{wth}{nominal wall thickness of the pipe, [\emph{inch}]. Type: \code{\link{assert_double}}.}

\item{depth}{measured maximum depth of the corroded area, [\emph{inch}].
Type: \code{\link{assert_double}}.}

\item{l}{measured maximum longitudinal length of the corroded area, [\emph{inch}].
Type: \code{\link{assert_double}}.}
}
\value{
allowable length of the corroded area in the pipe, [\emph{inch}].
 Type: \code{\link{assert_double}}.
}
\description{
Calculate allowable length of the corroded area in the pipe.
}
\examples{
 b31gacl(1093, 910, 30, .438, .1, 7.5)
 # [1] Inf  # [inch] - corrosion is low, no limit for the corroded area length

 b31gacl(438, 400, 20, .25, .18, 10)
 # [1] 2.018  # [inch] - finite allowed length of the corroded area


}
\references{
\href{https://law.resource.org/pub/us/cfr/ibr/002/asme.b31g.1991.pdf}{ASME B31G-1991}.
 Manual for determining the remaining strength of corroded pipelines. A
 supplement to \emph{ASTME B31} code for pressure piping.
}
\seealso{
Other ASME B31G functions: 
\code{\link{b31crvl}()},
\code{\link{b31gacd}()},
\code{\link{b31gafr}()},
\code{\link{b31gdep}()},
\code{\link{b31gmodpf}()},
\code{\link{b31gops}()},
\code{\link{b31gpf}()},
\code{\link{b31gsap}()}
}
\concept{ASME B31G functions}
