% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PivotTable.R
\docType{class}
\name{PivotTable}
\alias{PivotTable}
\title{A class that defines a pivot table.}
\format{\code{\link{R6Class}} object.}
\usage{
PivotTable
}
\value{
Object of \code{\link{R6Class}} with properties and methods that
  define a pivot table.
}
\description{
The PivotTable class represents a pivot table and is the primary class for
constructing and interacting with the pivot table.
}
\section{Fields}{

\describe{
\item{\code{argumentCheckMode}}{A number (0-4 meaning none, minimal, basic,
balanced, full) indicating the argument checking level.}

\item{\code{processingLibrary}}{A character value indicating the processing library
being used (base, dplyr, data.table).}

\item{\code{data}}{A PivotData object containing the data frames used to populate
the pivot table.}

\item{\code{rowGroup}}{The top PivotDataGroup in the parent-child hierarchy of row
data groups.}

\item{\code{columnGroup}}{The top PivotDataGroup in the parent-child hierarchy of
column data groups.}

\item{\code{calculationGroups}}{A PivotCalculationGroups object containing all of
the pivot calculations in the pivot table.}

\item{\code{calculationsPosition}}{"row" or "column" indicating where the
calculation names will appear (only if multiple calculations are defined
and visible in the pivot table).}

\item{\code{evaluationMode}}{Either "sequential" or "batch" to specify how summary
calculations (i.e. where type="summary") are evaluated.}

\item{\code{batchInfo}}{Get a text summary of the batch calculations from the last
evaluation of this pivot table.}

\item{\code{cells}}{A PivotCells object containing all of the cells in the body of
the pivot table.}

\item{\code{theme}}{The name of the theme currently applied to the pivot table.}

\item{\code{styles}}{A PivotStyles object containing the styles used to theme the
pivot table.}

\item{\code{allowExternalStyles}}{Enable support for external styles, when producing
content for external systems.}

\item{\code{allTimings}}{The time taken for various activities related to
constructing the pivot table.}

\item{\code{significantTimings}}{The time taken for various activities related to
constructing the pivot table, where the elapsed time > 0.1 seconds.}
}}

\section{Methods}{

\describe{
  \item{Documentation}{For more complete explanations and examples please see
  the extensive vignettes supplied with this package.}
  \item{\code{new(processingLibrary="auto", traceEnabled=FALSE,
  traceFile=NULL, argumentCheckMode="auto")}}{Create a new pivot table,
  including optionally enabling debug logging.}

  \item{\code{addData(df, dataName)}}{Add a data frame with the specified
  name to the pivot table.}
  \item{\code{getTopColumnGroups()}}{Get the very top column PivotDataGroup
  that sits at the top of the parent-child hierarchy.}
  \item{\code{getLeafColumnGroups()}}{Get the PivotDataGroups at the bottom
  of the column heading parent-child hierarchy.}
  \item{\code{addColumnDataGroups(variableName, atLevel, fromData=TRUE,
  dataName, dataSortOrder="asc", dataFormat, onlyCombinationsThatExist=TRUE,
  explicitListOfValues, calculationGroupName, expandExistingTotals=FALSE,
  addTotal=TRUE, visualTotals=FALSE, totalPosition="after",
  totalCaption="Total", preGroupData=TRUE)}}{Generate new column heading data
  groups based on the distinct values in a data frame or using explicitly
  specified data values.}
  \item{\code{normaliseColumnGroups() }}{Normalise the column heading data
  group hierachy so that all branches have the same number of levels -
  accomplished by adding empty child data groups where needed.}
  \item{\code{sortColumnDataGroups(levelNumber=1, orderBy="calculation",
  sortOrder="desc", calculationGroupName="default", calculationName)}}{Sort
  the column heading data groups either by the data group data value, caption
  or based on calculation result values.}
  \item{\code{getTopRowGroups()}}{Get the left-most row PivotDataGroup that
  sits at the top of the parent-child hierarchy.}
  \item{\code{getLeafRowGroups()}}{Get the PivotDataGroups at the bottom of
  the row heading parent-child hierarchy.}
  \item{\code{addRowDataGroups(variableName, atLevel, fromData=TRUE,
  dataName, dataSortOrder="asc", dataFormat, onlyCombinationsThatExist=TRUE,
  explicitListOfValues, calculationGroupName, expandExistingTotals=FALSE,
  addTotal=TRUE, visualTotals=FALSE, totalPosition="after",
  totalCaption="Total", preGroupData=TRUE)}}{Generate new row heading data
  groups based on the distinct values in a data frame or using explicitly
  specified data values.}
  \item{\code{normaliseRowGroups()}}{Normalise the row heading data group
  hierachy so that all branches have the same number of levels - accomplished
  by adding empty child data groups where needed.}
  \item{\code{sortRowDataGroups(levelNumber=1, orderBy="calculation",
  sortOrder="desc", calculationGroupName="default", calculationName)}}{Sort
  the row heading data groups either by the data group data value, caption or
  based on calculation result values.}
  \item{\code{addCalculationGroup(calculationGroupName)}}{Create a new
  calculation group (rarely needed since the default group is sufficient for
  almost all scenarios).}
  \item{\code{defineCalculation(calculationGroupName="default",
  calculationName, caption, visible=TRUE, displayOrder, filters, format,
  dataName, type="summary", valueName, summariseExpression,
  calculationExpression, calculationFunction, basedOn, noDataValue,
  noDataCaption)}}{Define a new calculation.  See the PivotCalculation class
  for details.}
  \item{\code{addColumnCalculationGroups(calculationGroupName="default",
  atLevel)}}{Add calculation names on columns (if more than one calculation
  is defined and visible, then the calculation names will appear as column
  headings).}
  \item{\code{addRowCalculationGroups(calculationGroupName="default",
  atLevel)}}{Add calculation names on rows (if more than one calculation is
  defined and visible, then the calculation names will appear as row
  headings).}
  \item{\code{addStyle(styleName, declarations)}}{Define a new PivotStyle and
  add it to the PivotStyles collection.}
  \item{\code{createInlineStyle(baseStyleName, declarations)}}{Create a
  PivotStyle object that can be used to style individual cell in the pivot
  table.}
  \item{\code{generateCellStructure()}}{Generate the empty pivot table cells
  (after the row/column headings have been defined).}
  \item{\code{resetCells()}}{Clear the cells of the pivot table (should be
  done automatically after structural changes have been made to the pivot
  table).}
  \item{\code{evaluateCells()}}{Calculate the values of the cells in the body
  of the pivot table.}
  \item{\code{evaluatePivot()}}{A wrapper for calling
  normaliseColumnGroups(), normaliseRowGroups(), generateCellStructure() and
  evaluateCells() in sequence.}
  \item{\code{findRowDataGroups(matchMode="simple", variableNames=NULL,
  variableValues=NULL, totals="include", calculationNames=NULL,
  includeDescendantGroups=FALSE)}}{Find row data groups matching the
  specified criteria.}
  \item{\code{findColumnDataGroups(matchMode="simple", variableNames=NULL,
  variableValues=NULL, totals="include", calculationNames=NULL,
  includeDescendantGroups=FALSE)}}{Find column data groups matching the
  specified criteria.}
  \item{\code{getCells(specifyCellsAsList=FALSE, rowNumbers=NULL,
  columnNumbers=NULL, cellCoordinates=NULL)}}{Retrieve cells by a combination
  of row and/or column numbers.}
  \item{\code{findCells(variableNames=NULL, variableValues=NULL,
  totals="include", calculationNames=NULL, minValue=NULL, maxValue=NULL,
  exactValues=NULL, includeNull=TRUE, includeNA=TRUE)}}{Find cells in the
  body of the pivot table matching the specified criteria.}
  \item{\code{print(asCharacter=FALSE)}}{Either print the pivot table to the
  console or retrieve it as a character value.}
  \item{\code{asMatrix(includeHeaders=TRUE, repeatHeaders=FALSE,
  rawValue=FALSE)}}{Gets the pivot table as a matrix, with or without
  headings.}
  \item{\code{asDataFrame(separator=" ")}}{Gets the pivot table as a data
  frame, combining multiple levels of headings with the specified separator.}
  \item{\code{asTidyDataFrame(includeGroupCaptions=TRUE,
  includeGroupValues=TRUE, separator=" ")}}{Gets the pivot table as a tidy
  data frame, where each cell in the body of the pivot table becomes one row
  in the data frame.}
  \item{\code{getCss(styleNamePrefix)}}{Get the CSS declarations for the
  entire pivot table.}
  \item{\code{getHtml(styleNamePrefix, includeHeaderValues=FALSE,
  includeRCFilters=FALSE, includeCalculationFilters=FALSE,
  includeWorkingData=FALSE, includeEvaluationFilters=FALSE,
  includeCalculationNames=FALSE, includeRawValue=FALSE,
  includeTotalInfo=FALSE)}}{Get the HTML representation of the pivot table,
  specifying the CSS style name prefix to use and whether additional debug
  information should be included in the pivot table.}
  \item{\code{saveHtml(filePath, fullPageHTML=TRUE, styleNamePrefix,
  includeHeaderValues=FALSE, includeRCFilters=FALSE,
  includeCalculationFilters=FALSE, includeWorkingData=FALSE,
  includeEvaluationFilters=FALSE, includeCalculationNames=FALSE,
  includeRawValue=FALSE, includeTotalInfo=FALSE)}}{Save the HTML
  representation of the pivot table to a file.}
  \item{\code{renderPivot(width, height, styleNamePrefix,
  includeHeaderValues=FALSE, includeRCFilters=FALSE,
  includeCalculationFilters=FALSE, includeWorkingData=FALSE,
  includeEvaluationFilters=FALSE, includeCalculationNames=FALSE,
  includeRawValue=FALSE, includeTotalInfo=FALSE)}}{Render the pivot table as
  a htmlwidget.}
  \item{\code{getLatex(caption=NULL, label=NULL, fromRow=NULL, toRow=NULL,
  fromColumn=NULL, toColumn=NULL, boldHeadings=FALSE,
  italicHeadings=FALSE)}}{Get the Latex representation of the pivot table,
  specifying the caption to appear above the table, the label to use when
  referring to the table elsewhere in the document and how headings should be
  styled.}
  \item{\code{showBatchInfo()}}{Show a text summary of the batch calculations
  from the last evaluation of this pivot table.}
  \item{\code{asList()}}{Get a list representation of the pivot table.}
  \item{\code{asJSON()}}{Get a JSON representation of the pivot table.}
  \item{\code{viewJSON()}}{View the JSON representation of the pivot table.}
}
}

\examples{
# The package vignettes have many more examples of working with the
# PivotTable class.
library(pivottabler)
pt <- PivotTable$new()
pt$addData(bhmtrains)
pt$addColumnDataGroups("TrainCategory")
pt$addRowDataGroups("TOC")
pt$defineCalculation(calculationName="TotalTrains",
summariseExpression="n()")
pt$renderPivot()
}
\keyword{datasets}
