#' Paste copied packages to another environment
#'
#' \code{pkg_paste()} retrieve copied R package information through the
#' download code generated by \code{pkg_copy()}. It then compares it with the
#' package information in the current environment. If it detects any new
#' packages, it will attempt to install them and report any packages that
#' cannot be installed. \code{pkg_paste_names()} does not attempt to install
#' packages, in case people want to revise the list before installation. \cr\cr
#' This function should be run in the new/target environment.
#'
#' @param code Download code returned by \code{pkg_backup()}.
#' @param lib.loc Library Location. It's an argument passed to
#' \code{installed.packages()}.
#' @param ... Arguments passed to \code{install.packages()}
#'
#' @importFrom utils install.packages
#' @importFrom httr write_disk GET
#'
#' @export

pkg_paste <- function(code, lib.loc = NULL, ...){
  pkgs_to_install <- pkg_paste_names(code = code, lib.loc = lib.loc)
  if(!is.null(pkgs_to_install)){
    install.packages(pkgs_to_install, ...)
  }
}

#' @rdname pkg_paste
#' @export

pkg_paste_names <- function(code, lib.loc = NULL){
  # Download list from the download code
  download_url <- paste0("https://a.uguu.se/", code, "_pkgs")
  temp_file <- tempfile()
  GET(download_url, write_disk(temp_file))

  cloud_pkgs <- readLines(temp_file)
  local_pkgs <- dimnames(installed.packages(lib.loc = lib.loc))[[1]]
  pkgs_to_install <- cloud_pkgs[!cloud_pkgs %in% local_pkgs]
  if(length(pkgs_to_install) == 0){
    message("You have installed all the R packages you copied. ")
  }else{
    return(pkgs_to_install)
    }
}
