% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{mosaic_view}
\alias{mosaic_view}
\title{Mosaic View}
\usage{
mosaic_view(
  mosaic,
  r = 3,
  g = 2,
  b = 1,
  re = 4,
  nir = 5,
  title = "",
  viewer = c("mapview", "base"),
  show = c("rgb", "index"),
  index = "B",
  max_pixels = 5e+05,
  downsample = NULL,
  alpha = 1,
  quantiles = c(0, 1),
  domain = NULL,
  color_regions = custom_palette(),
  axes = FALSE,
  ...
)
}
\arguments{
\item{mosaic}{A mosaic of class \code{SpatRaster}, generally imported with
\code{\link[=mosaic_input]{mosaic_input()}}.}

\item{r}{The layer for the Red band (default: 3).}

\item{g}{The layer for the Green band (default: 2).}

\item{b}{The layer for the Blue band (default: 1).}

\item{re}{The layer for the Red-edge band (default: 4).}

\item{nir}{The layer for the Near-infrared band(default: 5).}

\item{title}{A title for the generated map or plot (default: "").}

\item{viewer}{The viewer option. If not provided, the value is retrieved
using \code{\link[=get_pliman_viewer]{get_pliman_viewer()}}. This option controls the type of viewer to use
for interactive plotting. The available options are "base" and "mapview".
If set to "base", the base R graphics system is used for interactive
plotting. If set to "mapview", the mapview package is used. To set this
argument globally for all functions in the package, you can use the
\code{\link[=set_pliman_viewer]{set_pliman_viewer()}} function. For example, you can run
\code{set_pliman_viewer("mapview")} to set the viewer option to "mapview" for
all functions.}

\item{show}{The display option for the map view. Options are "rgb" for RGB
view and "index" for index view.}

\item{index}{The index to use for the index view. Defaults to "B".}

\item{max_pixels}{Maximum number of pixels to render in the map or plot
(default: 500000).}

\item{downsample}{Downsampling factor to reduce the number of pixels
(default: NULL). In this case, if the number of pixels in the image (width
x height) is greater than \code{max_pixels} a downsampling factor will be
automatically chosen so that the number of plotted pixels approximates the
\code{max_pixels}.}

\item{alpha}{opacity of the fill color of the raster layer(s).}

\item{quantiles}{the upper and lower quantiles used for color stretching. If
set to \code{NULL}, stretching is performed basing on 'domain' argument.}

\item{domain}{the upper and lower values used for color stretching. This is
used only if \code{'quantiles'} is \code{NULL}. If both '\verb{domain'} and \code{'quantiles'} are
set to \code{NULL}, stretching is applied based on min-max values.}

\item{color_regions}{The color palette for displaying index values. Default
is \code{\link[=custom_palette]{custom_palette()}}.}

\item{axes}{logical. Draw axes? Defaults to \code{FALSE}.}

\item{...}{Additional arguments passed on to \code{\link[terra:plot]{terra::plot()}} when \code{viewer = "base"}.}
}
\value{
An sf object, the same object returned by \code{\link[mapedit:editMap]{mapedit::editMap()}}.
}
\description{
Mosaic View
}
\details{
The function can generate either an interactive map using the
'mapview' package or a static plot using the 'base' package, depending on
the \code{viewer} and \code{show} parameters. If show = "index" is used, the function
first computes an image index that can be either an RGB-based index or a
multispectral index, if a multispectral mosaic is provided.
}
\examples{
if(interactive()){
library(pliman)
# Load a raster showing the elevation of Luxembourg
mosaic <- mosaic_input(system.file("ex/elev.tif", package="terra"))

# Generate an interactive map using 'mapview'
mosaic_view(mosaic)

# Generate a static plot using 'base'
mosaic_view(mosaic, viewer = "base")
}


}
