% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_objects.R
\name{utils_objects}
\alias{utils_objects}
\alias{object_coord}
\alias{object_contour}
\alias{object_isolate}
\alias{object_id}
\title{Utilities for working with image objects}
\usage{
object_coord(
  img,
  id = NULL,
  index = "NB",
  watershed = TRUE,
  invert = FALSE,
  opening = FALSE,
  closing = FALSE,
  filter = FALSE,
  fill_hull = FALSE,
  threshold = "Otsu",
  edge = 2,
  extension = NULL,
  tolerance = NULL,
  object_size = "medium",
  parallel = FALSE,
  workers = NULL,
  plot = TRUE
)

object_contour(
  img,
  pattern = NULL,
  dir_original = NULL,
  center = FALSE,
  index = "NB",
  invert = FALSE,
  opening = FALSE,
  closing = FALSE,
  filter = FALSE,
  fill_hull = FALSE,
  threshold = "Otsu",
  watershed = TRUE,
  extension = NULL,
  tolerance = NULL,
  object_size = "medium",
  parallel = FALSE,
  workers = NULL,
  plot = TRUE,
  verbose = TRUE
)

object_isolate(img, id = NULL, parallel = FALSE, workers = NULL, ...)

object_id(img, parallel = FALSE, workers = NULL, ...)
}
\arguments{
\item{img}{An image of class \code{Image} or a list of \code{Image} objects.}

\item{id}{\itemize{
\item For \code{object_coord()}, a vector (or scalar) of object \code{id} to compute the
bounding rectangle. Object ids can be obtained with \code{\link[=object_id]{object_id()}}. Set \code{id = "all"} to compute the coordinates for all objects in the image. If \code{id = NULL} (default) a bounding rectangle is drawn including all the objects.
\item For \code{object_isolate()}, a scalar that identifies the object to be extracted.
}}

\item{index}{The index to produce a binary image used to compute bounding
rectangle coordinates. See \code{\link[=image_binary]{image_binary()}} for more details.}

\item{watershed}{If \code{TRUE} (default) performs watershed-based object
detection. This will detect objects even when they are touching one other.
If \code{FALSE}, all pixels for each connected set of foreground pixels are set
to a unique object. This is faster but is not able to segment touching
objects.}

\item{invert}{Inverts the binary image, if desired. Defaults to \code{FALSE}.}

\item{opening, closing, filter}{\strong{Morphological operations (brush size)}
\itemize{
\item \code{opening} performs an erosion followed by a dilation. This helps to
remove small objects while preserving the shape and size of larger objects.
\item \code{closing} performs a dilatation followed by an erosion. This helps to
fill small holes while preserving the shape and size of larger objects.
\item \code{filter} performs median filtering in the binary image. Provide a positive
integer > 1 to indicate the size of the median filtering. Higher values are
more efficient to remove noise in the background but can dramatically impact
the perimeter of objects, mainly for irregular perimeters such as leaves
with serrated edges.
}

Hierarchically, the operations are performed as opening > closing > filter.
The value declared in each argument will define the brush size.}

\item{fill_hull}{Fill holes in the objects? Defaults to \code{FALSE}.}

\item{threshold}{By default (\code{threshold = "Otsu"}), a threshold value based
on Otsu's method is used to reduce the grayscale image to a binary image.
If a numeric value is informed, this value will be used as a threshold.
Inform any non-numeric value different than "Otsu" to iteratively chosen
the threshold based on a raster plot showing pixel intensity of the index.}

\item{edge}{The number of pixels in the edge of the bounding rectangle.
Defaults to \code{2}.}

\item{extension, tolerance, object_size}{Controls the watershed segmentation of
objects in the image. See \code{\link[=analyze_objects]{analyze_objects()}} for more details.}

\item{parallel}{Processes the images asynchronously (in parallel) in separate
R sessions running in the background on the same machine. It may speed up
the processing time when \code{image} is a list. The number of sections is set
up to 50\% of available cores.}

\item{workers}{A positive numeric scalar or a function specifying the maximum
number of parallel processes that can be active at the same time.}

\item{plot}{Shows the image with bounding rectangles? Defaults to
\code{TRUE}.}

\item{pattern}{A pattern of file name used to identify images to be imported.
For example, if \code{pattern = "im"} all images in the current working directory
that the name matches the pattern (e.g., img1.-, image1.-, im2.-) will be
imported as a list. Providing any number as pattern (e.g., \code{pattern = "1"})
will select images that are named as 1.-, 2.-, and so on. An error will be
returned if the pattern matches any file that is not supported (e.g.,
img1.pdf).}

\item{dir_original}{The directory containing the original images. Defaults
to \code{NULL}, which means that the current working directory will be
considered.}

\item{center}{If \code{TRUE} returns the object contours centered on the origin.}

\item{verbose}{If \code{TRUE} (default) a summary is shown in the console.}

\item{...}{\itemize{
\item For \code{object_isolate()}, further arguments passed on to \code{\link[=object_coord]{object_coord()}}.
\item For \code{object_id()}, further arguments passed on to \code{\link[=analyze_objects]{analyze_objects()}}.
}}
}
\value{
\itemize{
\item \code{object_id()} An image of class \code{"Image"} containing the object's
identification.
\item \code{object_coord()} A list with the coordinates for the bounding rectangles.
If \code{id = "all"} or a numeric vector, a list with a vector of coordinates is
returned.
\item \code{object_isolate()} An image of class \code{"Image"} containing the isolated
object.
}
}
\description{
\itemize{
\item \code{object_id()} get the object identification in an image.
\item \code{object_coord()} get the object coordinates and (optionally) draw a
bounding rectangle around multiple objects in an image.
\item \code{object_contour()} returns the coordinates (\code{x} and \code{y}) for the contours
of each object in the image.
\item \code{object_isolate()} isolates an object from an image.
}
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
img <- image_pliman("la_leaves.jpg")
# Get the object's (leaves) identification
object_id(img)

# Get the coordinates and draw a bounding rectangle around leaves 1 and 3
object_coord(img, id = c(1, 3))

# Isolate leaf 3
isolated <- object_isolate(img, id = 3)
plot(isolated)

}
}
