% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{mosaic_epsg}
\alias{mosaic_epsg}
\title{Determine EPSG Code for a Mosaic}
\usage{
mosaic_epsg(mosaic)
}
\arguments{
\item{mosaic}{A raster object representing the mosaic for which the EPSG code
is to be determined.}
}
\value{
A character string representing the EPSG code corresponding to the
UTM zone and hemisphere of the mosaic's centroid. If the mosaic is not in
the lon/lat coordinate system, a warning is issued.
}
\description{
This function calculates the EPSG code for a given mosaic based on its
geographic extent.
}
\details{
The function calculates the centroid of the mosaic's extent,
determines the UTM zone based on the centroid's longitude, and identifies
the hemisphere based on the centroid's latitude. The EPSG code is then
constructed accordingly.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
library(terra)

# Create a sample mosaic
mosaic <- rast(nrow=10, ncol=10, xmin=-120, xmax=-60, ymin=30, ymax=60)

# Get the EPSG code for the mosaic
mosaic_epsg(mosaic)
}

}
