% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individualQC.R
\name{run_check_relatedness}
\alias{run_check_relatedness}
\title{Run PLINK IBD estimation}
\usage{
run_check_relatedness(indir, name, qcdir = indir, highIBDTh = 0.185,
  path2plink = NULL, showPlinkOutput = TRUE, verbose = FALSE)
}
\arguments{
\item{indir}{[character] /path/to/directory containing the basic PLINK data
files name.bim, name.bed, name.fam files.}

\item{name}{[character] Prefix of PLINK files, i.e. name.bed, name.bim,
name.fam.}

\item{qcdir}{[character] /path/to/directory to save name.genome as returned
by plink --genome. User needs writing permission to qcdir. Per default
qcdir=indir.}

\item{highIBDTh}{[double] Threshold for acceptable proportion of IBD between
pair of individuals; only pairwise relationship estimates larger than this
threshold will be recorded.}

\item{path2plink}{[character] Absolute path to directory where external plink
software \url{https://www.cog-genomics.org/plink/1.9/} can be found, i.e.
plink should be accessible as path2plink/plink -h. If not
provided, assumed that PATH set-up works and plink will be found by
system("plink").}

\item{showPlinkOutput}{[logical] If TRUE, plink log and error messages are
printed to standard out.}

\item{verbose}{[logical] If TRUE, progress info is printed to standard out.}
}
\description{
Run LD pruning on dataset with plink --exclude range highldfile
--indep-pairwise 50 5 0.2, where highldfile contains regions of high LD as
provided by Anderson et (2010) Nature Protocols. Subsequently, plink
--genome is run on the LD pruned data. plink --genome calculates identity
by state (IBS) for each pair of individuals based on the average proportion
of alleles shared at genotyped SNPs. The degree of recent shared ancestry,
i.e. the identity by descent (IBD) can be estimated from the genome-wide IBS.
The proportion of IBD between two individuals is returned by --genome as
PI_HAT.
}
\details{
Both \code{\link{run_check_relatedness}} and its evaluation via
\code{\link{evaluate_check_relatedness}} can simply be invoked by
\code{\link{check_relatedness}}.
}
\examples{
indir <- system.file("extdata", package="plinkQC")
name <- 'data'
qcdir <- tempdir()
# the following code is not run on package build, as the path2plink on the
# user system is not known.
\dontrun{
run <- run_check_relatedness(indir=indir, qcdir=qcdir, name=name)
}
}
