% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/FunctionXform.R
\name{FunctionXform}
\alias{FunctionXform}
\title{Add a function transformation to a WrapData object.}
\usage{
FunctionXform(boxdata, origFieldName, newFieldName = "newField",
  newFieldDataType = "numeric", formulaText, mapMissingTo = NA)
}
\arguments{
\item{boxdata}{wrapper object obtained by using the WrapData function on raw data}

\item{origFieldName}{string specifying name(s) of the original data field(s) being used in the transformation}

\item{newFieldName}{name of the new field created by the transformation}

\item{newFieldDataType}{data type of the new field created by the transformation}

\item{formulaText}{string expression specifying the transformation}

\item{mapMissingTo}{value to be given to the transformed variable if the value of any input variable is missing}
}
\value{
R object containing the raw data, the transformed data and data statistics.
The \code{data} data frame will contain a new \code{newFieldName} column, and
\code{fieldData} will contain a new \code{newFieldName} row.
}
\description{
Add a function transformation to a WrapData object.
}
\details{
Calculate the expression provided
in formulaText for every row in the \code{boxdata$data}
data frame. The \code{formulaText} argument must represent
a valid R expression, and any functions used in
\code{formulaText} must be defined in the current
environment.

The name of the new field is optional (a default name is provided), but an error
will be thrown if attempting to create a field with a name that already exists in
the WrapData object.
}
\examples{
# Load the standard iris dataset
data(iris)

# Wrap the data
irisBox <- WrapData(iris)

# Perform a transform on the Sepal.Length field:
# the value is squared and then divided by 100
irisBox <- FunctionXform(irisBox,origFieldName="Sepal.Length",
                         newFieldName="Sepal.Length.Transformed",
                         formulaText="(Sepal.Length^2)/100")

# Combine two fields to create another new feature:
irisBox <- FunctionXform(irisBox,
                         origFieldName="Sepal.Width, Petal.Width",
                         newFieldName="Width.Sum",
                         formulaText="Sepal.Width + Sepal.Length")

# Create linear model using the derived features
fit <- lm(Petal.Length ~
         Sepal.Length.Transformed + Width.Sum, data=irisBox$data)

# Create pmml from the fit
library(pmml)
fit_pmml <- pmml(fit, transform=irisBox)
}
\author{
Dmitriy Bolotov
}
\seealso{
\code{\link{WrapData}}
}

