% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yaml_read_agent.R
\name{yaml_agent_interrogate}
\alias{yaml_agent_interrogate}
\title{Get an \emph{agent} from \strong{pointblank} YAML and \code{interrogate()}}
\usage{
yaml_agent_interrogate(filename, path = NULL)
}
\arguments{
\item{filename}{The name of the YAML file that contains fields related to an
\emph{agent}.}

\item{path}{An optional path to the YAML file (combined with \code{filename}).}
}
\value{
A \code{ptblank_agent} object.
}
\description{
The \code{yaml_agent_interrogate()} function operates much like the
\code{\link[=yaml_read_agent]{yaml_read_agent()}} function (reading a \strong{pointblank} YAML file and
generating an \emph{agent} with a validation plan in place). The key difference is
that this function takes things a step further and interrogates the target
table (defined by table-prep formula that is required in the YAML file). The
additional auto-invocation of \code{\link[=interrogate]{interrogate()}} uses the default options of
that function. As with \code{\link[=yaml_read_agent]{yaml_read_agent()}} the agent is returned except, this
time, it has intel from the interrogation.
}
\section{Examples}{


There's a YAML file available in the \strong{pointblank} package that's also
called \code{"agent-small_table.yml"}. The path for it can be accessed through
\code{system.file()}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{yml_file_path <- 
  system.file(
    "yaml", "agent-small_table.yml",
    package = "pointblank"
  )
}\if{html}{\out{</div>}}

The YAML file can be read as an agent with a pre-existing validation plan by
using the \code{\link[=yaml_read_agent]{yaml_read_agent()}} function.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{agent <- yaml_read_agent(filename = yml_file_path)

agent
}\if{html}{\out{</div>}}

\if{html}{
\out{
<img src="https://raw.githubusercontent.com/rich-iannone/pointblank/main/images/man_yaml_write_1.png" alt="This image was generated from the first code example in the `yaml_write()` help file." style="width:100\%;">
}
}

This particular agent is using \code{~ tbl_source("small_table", "tbl_store.yml")}
to source the table-prep from a YAML file that holds a table store (can be
seen using \code{yaml_agent_string(agent = agent)}). Let's put that file in the
working directory (the \strong{pointblank} package has the corresponding YAML
file):

\if{html}{\out{<div class="sourceCode r">}}\preformatted{yml_tbl_store_path <-
  system.file(
    "yaml", "tbl_store.yml",
    package = "pointblank"
  )

file.copy(from = yml_tbl_store_path, to = ".")
}\if{html}{\out{</div>}}

As can be seen from the validation report, no interrogation was yet
performed. Saving an agent to YAML will remove any traces of interrogation
data and serve as a plan for a new interrogation on the same target table. We
can either follow this up with with \code{\link[=interrogate]{interrogate()}} and get an agent with
intel, or, we can interrogate directly from the YAML file with
\code{yaml_agent_interrogate()}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{agent <- yaml_agent_interrogate(filename = yml_file_path)

agent
}\if{html}{\out{</div>}}

\if{html}{
\out{
<img src="https://raw.githubusercontent.com/rich-iannone/pointblank/main/images/man_yaml_write_2.png" alt="This image was generated from the second code example in the `yaml_write()` help file." style="width:100\%;">
}
}
}

\section{Function ID}{

11-4
}

\seealso{
Other pointblank YAML: 
\code{\link{yaml_agent_show_exprs}()},
\code{\link{yaml_agent_string}()},
\code{\link{yaml_exec}()},
\code{\link{yaml_informant_incorporate}()},
\code{\link{yaml_read_agent}()},
\code{\link{yaml_read_informant}()},
\code{\link{yaml_write}()}
}
\concept{pointblank YAML}
