% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_informant.R
\name{create_informant}
\alias{create_informant}
\title{Create a \strong{pointblank} \emph{informant} object}
\usage{
create_informant(
  tbl = NULL,
  read_fn = NULL,
  agent = NULL,
  tbl_name = NULL,
  label = NULL,
  lang = NULL,
  locale = NULL
)
}
\arguments{
\item{tbl}{The input table. This can be a data frame, a tibble, a \code{tbl_dbi}
object, or a \code{tbl_spark} object. Alternatively, a function can be used to
read in the input data table with the \code{read_fn} argument (in which case,
\code{tbl} can be \code{NULL}).}

\item{read_fn}{A function that's used for reading in the data. Even if a
\code{tbl} is provided, this function will be invoked to obtain the data (i.e.,
the \code{read_fn} takes priority). There are two ways to specify a \code{read_fn}:
(1) using a function (e.g., \verb{function() \{ <table reading code> \}}) or, (2)
with an R formula expression.}

\item{agent}{A pointblank \emph{agent} object. This object can be used instead of
supplying a table in \code{tbl} or a table-reading function in \code{read_fn}.}

\item{tbl_name}{A optional name to assign to the input table object. If no
value is provided, a name will be generated based on whatever information
is available.}

\item{label}{An optional label for the information report. If no value is
provided, a label will be generated based on the current system time.
Markdown can be used here to make the label more visually appealing (it
will appear in the header area of the information report).}

\item{lang}{The language to use for the information report (a summary table
that provides all of the available information for the table. By default,
\code{NULL} will create English (\code{"en"}) text. Other options include French
(\code{"fr"}), German (\code{"de"}), Italian (\code{"it"}), Spanish (\code{"es"}), Portuguese,
(\code{"pt"}), Chinese (\code{"zh"}), and Russian (\code{"ru"}).}

\item{locale}{An optional locale ID to use for formatting values in the
information report according the locale's rules. Examples include \code{"en_US"}
for English (United States) and \code{"fr_FR"} for French (France); more simply,
this can be a language identifier without a country designation, like "es"
for Spanish (Spain, same as \code{"es_ES"}).}
}
\value{
A \code{ptblank_informant} object.
}
\description{
The \code{create_informant()} function creates an \emph{informant} object, which is
used in an \emph{information management} workflow. The overall aim of this
workflow is to record, collect, and generate useful information on data
tables. We can supply as information that is useful for describing a
particular data table. The \emph{informant} object created by the
\code{create_informant()} function takes information-focused functions (the
\verb{info_*()} series of functions).
}
\section{Figures}{

\if{html}{\figure{man_create_informant_1.png}{options: width=100\%}}
}

\section{Function ID}{

1-3
}

\examples{
# Let's walk through how we can
# generate some useful information for a
# really small table; it's actually
# called `small_table` and we can find
# it as a dataset in this package
small_table

# Create a pointblank `informant`
# object with `create_informant()`
# and the `small_table` dataset
informant <- 
  create_informant(
    read_fn = ~small_table,
    tbl_name = "small_table",
    label = "An example."
  )

# This function creates some information
# without any extra help by profiling
# the supplied table object; it adds
# the sections: (1) 'table' and
# (2) 'columns' and we can print the
# object to see the information report

# Alternatively, we can get the same report
# by using `get_informant_report()`
report <- get_informant_report(informant)
class(report)

}
\seealso{
Other Planning and Prep: 
\code{\link{action_levels}()},
\code{\link{col_schema}()},
\code{\link{create_agent}()},
\code{\link{db_tbl}()},
\code{\link{scan_data}()},
\code{\link{validate_rmd}()}
}
\concept{Planning and Prep}
