% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yaml_exec.R
\name{yaml_exec}
\alias{yaml_exec}
\title{Execute all agent and informant YAML tasks}
\usage{
yaml_exec(
  path = NULL,
  files = NULL,
  write_to_disk = TRUE,
  output_path = NULL,
  keep_tbl = FALSE,
  keep_extracts = FALSE
)
}
\arguments{
\item{path}{The path that contains the YAML files for agents and informants.}

\item{files}{A vector of YAML files to use. By default, \code{yaml_exec()} will
attempt to process every valid YAML file but supplying a vector here limits
the scope to the specified files.}

\item{write_to_disk}{Should the processing include a step that writes output
files to disk? This uses \code{\link[=x_write_disk]{x_write_disk()}} to write RDS files and uses the
base filename of the agent/informant YAML file, adding the date-time to the
output filename.}

\item{output_path}{The output path for any generated output files. By
default, this will be a subdirectory of the provided \code{path} called
\code{"output"}.}

\item{keep_tbl, keep_extracts}{For agents, the table may be kept if it is a
dataframe object and \emph{extracts} (collections of table rows that failed a
validation step) may also be stored. By default, both of these options are
set to \code{FALSE}.}
}
\description{
The \code{yaml_exec()} function takes all relevant \strong{pointblank} YAML files in a
directory and executes them. Execution involves interrogation of agents for
YAML agents and incorporation of informants for YAML informants. Under the
hood, this uses \code{\link[=yaml_agent_interrogate]{yaml_agent_interrogate()}} and \code{\link[=yaml_informant_incorporate]{yaml_informant_incorporate()}}
and then \code{\link[=x_write_disk]{x_write_disk()}} to save the processed objects to an output
directory for access to fresh results.

The output RDS files are named according to the object type processed, the
target table, and the date-time of processing. For convenience and
modularity, this setup is ideal when a table store YAML file (typically named
\code{"tbl_store.yml"} and produced via the \code{\link[=tbl_store]{tbl_store()}} and \code{\link[=yaml_write]{yaml_write()}}
workflow) is available in the directory, and when table-prep formulas are
accessed by name through \code{\link[=tbl_source]{tbl_source()}}.

A typical directory of files set up for execution in this way might have the
following contents:
\itemize{
\item a \code{"tbl_store.yml"} file for holding table-prep formulas (created with
\code{\link[=tbl_store]{tbl_store()}} and written to YAML with \code{\link[=yaml_write]{yaml_write()}})
\item one or more YAML \emph{agent} files to validate tables (ideally using
\code{\link[=tbl_source]{tbl_source()}})
\item one or more YAML \emph{informant} files to provide refreshed metadata on tables
(again, using \code{\link[=tbl_source]{tbl_source()}} to reference table preparations is ideal)
\item an output folder (default is \code{"output"}) to save serialized versions of
processed agents and informants
}
}
\section{Function ID}{

11-8
}

\seealso{
Other pointblank YAML: 
\code{\link{yaml_agent_interrogate}()},
\code{\link{yaml_agent_show_exprs}()},
\code{\link{yaml_agent_string}()},
\code{\link{yaml_informant_incorporate}()},
\code{\link{yaml_read_agent}()},
\code{\link{yaml_read_informant}()},
\code{\link{yaml_write}()}
}
\concept{pointblank YAML}
