% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_transformers.R
\name{get_tt_param}
\alias{get_tt_param}
\title{Get a parameter value from a summary table}
\usage{
get_tt_param(tbl, param, column = NULL)
}
\arguments{
\item{tbl}{A summary table generated by either of the \code{\link[=tt_summary_stats]{tt_summary_stats()}},
\code{\link[=tt_string_info]{tt_string_info()}}, \code{\link[=tt_tbl_dims]{tt_tbl_dims()}}, or \code{\link[=tt_tbl_colnames]{tt_tbl_colnames()}} functions.}

\item{param}{The parameter name associated to the value that is to be gotten.
These parameter names are always available in the first column (\code{.param.})
of a summary table obtained by \code{\link[=tt_summary_stats]{tt_summary_stats()}}, \code{\link[=tt_string_info]{tt_string_info()}},
\code{\link[=tt_tbl_dims]{tt_tbl_dims()}}, or \code{\link[=tt_tbl_colnames]{tt_tbl_colnames()}}.}

\item{column}{The column in the summary table for which the data value should
be obtained. This must be supplied for summary tables generated by
\code{\link[=tt_summary_stats]{tt_summary_stats()}} and \code{\link[=tt_string_info]{tt_string_info()}} (the \code{\link[=tt_tbl_dims]{tt_tbl_dims()}} and
\code{\link[=tt_tbl_colnames]{tt_tbl_colnames()}} functions will always generate a two-column summary
table).}
}
\description{
The \code{get_tt_param()} function can help you to obtain a single
parameter value from a summary table generated by the \verb{tt_*()} functions
\code{\link[=tt_summary_stats]{tt_summary_stats()}}, \code{\link[=tt_string_info]{tt_string_info()}}, \code{\link[=tt_tbl_dims]{tt_tbl_dims()}}, or
\code{\link[=tt_tbl_colnames]{tt_tbl_colnames()}}. The following parameters are to be used depending on the
input \code{tbl}:
\itemize{
\item from \code{\link[=tt_summary_stats]{tt_summary_stats()}}: \code{"min"}, \code{"p05"}, \code{"q_1"}, \code{"med"}, \code{"q_3"},
\code{"p95"}, \code{"max"}, \code{"iqr"}, \code{"range"}
\item from \code{\link[=tt_string_info]{tt_string_info()}}: \code{"length_mean"}, \code{"length_min"}, \code{"length_max"}
\item from \code{\link[=tt_tbl_dims]{tt_tbl_dims()}}: \code{"rows"}, \code{"columns"}
\item from \code{\link[=tt_tbl_colnames]{tt_tbl_colnames()}}: any integer present in the \code{.param.} column
}

The \code{\link[=tt_summary_stats]{tt_summary_stats()}} and \code{\link[=tt_string_info]{tt_string_info()}} functions will generate
summary tables with columns that mirror the numeric and character columns
in their input tables, respectively. For that reason, a column name must be
supplied to the \code{column} argument in \code{get_tt_param()}.
}
\section{Function ID}{

12-7
}

\examples{
# Get summary statistics for the
# first quarter of the `game_revenue`
# dataset that's included in the package
stat_tbl <- 
  game_revenue \%>\%
  tt_time_slice(slice_point = 0.25) \%>\%
  tt_summary_stats()

# Based on player behavior for the first
# quarter of the year, test whether the
# maximum session duration during the
# rest of the year is never higher
game_revenue \%>\%
  tt_time_slice(
    slice_point = 0.25,
    keep = "right"
  ) \%>\%
  test_col_vals_lte(
    columns = vars(session_duration), 
    value = get_tt_param(
      tbl = stat_tbl,
      param = "max",
      column = "session_duration"
    )
  )

}
\seealso{
Other Table Transformers: 
\code{\link{tt_string_info}()},
\code{\link{tt_summary_stats}()},
\code{\link{tt_tbl_colnames}()},
\code{\link{tt_tbl_dims}()},
\code{\link{tt_time_shift}()},
\code{\link{tt_time_slice}()}
}
\concept{Table Transformers}
