% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/politenessModel.R
\name{politenessModel}
\alias{politenessModel}
\title{Pre-Trained Politeness Classifier}
\usage{
politenessModel(texts, num_mc_cores = 1)
}
\arguments{
\item{texts}{character A vector of texts, each of which will be tallied for politeness features.}

\item{num_mc_cores}{integer Number of cores for parallelization.}
}
\value{
a vector with receptiveness scores
}
\description{
Pre-trained model to detect conversational receptiveness
}
\details{
This is a wrapper around a pre-trained model of "politeness" for all the data from the 2013 DNM et al paper.
This model requires grammar parsing via SpaCy. Please see \code{\link{spacyr}} for details on installation.
}
\examples{


\dontrun{
data("phone_offers")

politenessModel(phone_offers$message)

}

}
\references{
Danescu-Niculescu-Mizil, C., Sudhof, M., Jurafsky, D., Leskovec, J. & Potts, C. (2013). A computational approach to politeness with application to social factors. Proc. 51st ACL, 250-259.
}
