% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textTools.R
\name{textcounter}
\alias{textcounter}
\title{Text Counter}
\usage{
textcounter(
  counted,
  texts,
  words = FALSE,
  fixed = TRUE,
  start = FALSE,
  num_mc_cores = parallel::detectCores()
)
}
\arguments{
\item{counted}{character vector of items to search for in the texts.}

\item{texts}{character vector of to-be-searched text.}

\item{words}{logical. Default FALSE. Does \code{counted} contain words, or sequences of chracters?}

\item{fixed}{logical. Default TRUE. Use literal characters instead of regular expressions?}

\item{start}{logical. Default FALSE. Does \code{counted} only look at the start of a sentence?}

\item{num_mc_cores}{integer Number of cores for parallelization. Default is parallel::detectCores().}
}
\value{
numeric vector as long as \code{texts} indicating total frequencies of \code{counted} items.
}
\description{
Counts total prevalence of a set of items in each of a set of texts.
}
\keyword{internal}
