% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decode.R
\docType{methods}
\name{decode}
\alias{decode}
\alias{decode,character-method}
\alias{decode,slice-method}
\alias{decode,partition-method}
\title{Decode corpus or subcorpus.}
\usage{
decode(.Object, ...)

\S4method{decode}{character}(.Object, to = c("data.table", "Annotation"),
  ...)

\S4method{decode}{slice}(.Object, to = "data.table")

\S4method{decode}{partition}(.Object, to = "data.table")
}
\arguments{
\item{.Object}{The \code{corpus} or \code{subcorpus} to decode.}

\item{...}{Further arguments.}

\item{to}{The class of the returned object, stated as a length-one
\code{character} vector.}
}
\value{
The return value will correspond to the class specified by argument \code{to}.
}
\description{
Decode \code{corpus} or \code{subcorpus} and return class specified by argument \code{to}.
}
\details{
The primary purpose of the method is type conversion. By obtaining the corpus
or subcorpus in the format specified by the argument \code{to}, the data can
be processed with tools that do not rely on the Corpus Workbench (CWB).
Supported output formats are \code{data.table} (which can be converted to a
\code{data.frame} or \code{tibble} easily) or an \code{Annotation} object as
defined in the package \code{NLP}. Another purpose of decoding the corpus can
be to rework it, and to re-import it into the CWB (e.g. using the
\code{cwbtools}-package).

An earlier version of the method included an option to decode a single
s-attribute, which is not supported any more. See the \code{s_attribute_decode}
function of the package RcppCWB.
}
\examples{
use("polmineR")

# Decode corpus as data.table
dt <- decode("GERMAPARLMINI", to = "data.table")

# Decode a subcorpus
sc <- subset(corpus("GERMAPARLMINI"), speaker == "Angela Dorothea Merkel")
dt <- decode(sc, to = "data.table")

# Decode partition
P <- partition("REUTERS", places = "kuwait", regex = TRUE)
dt <- decode(P)

# Previous versions of polmineR offered an option to decode a single
# s-attribute. This is how you could proceed to get a table with metadata.
dt[, "word" := NULL]
dt[,
  {list(cpos_left = min(.SD[["cpos"]]), cpos_right = max(.SD[["cpos"]]), id = unique(.SD[["id"]]))},
  by = "struc"
  ]

# Decode subcorpus as Annotation object
\dontrun{
if (requireNamespace("NLP")){
  library(NLP)
  p <- subset(corpus("GERMAPARLMINI"), date == "2009-11-10" & speaker == "Angela Dorothea Merkel")
  s <- as(p, "String")
  a <- as(p, "Annotation")
  
  # The beauty of having this NLP Annotation object is that you can now use 
  # the different annotators of the openNLP package. Here, just a short scenario
  # how you can have a look at the tokenized words and the sentences.

  words <- s[a[a$type == "word"]]
  sentences <- s[a[a$type == "sentence"]] # does not yet work perfectly for plenary protocols 
}
}
}
\seealso{
To decode a structural attribute, you can use the
  \code{\link{s_attributes}}-method, setting argument \code{unique} as
  \code{FALSE} and \code{\link[RcppCWB]{s_attribute_decode}}. See
  \code{\link{as.VCorpus}} to decode a \code{partition_bundle} object,
  returning a \code{VCorpus} object.
}
