% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{annotations}
\alias{annotations}
\alias{annotations,kwic-method}
\alias{annotations,textstat-method}
\alias{annotations<-}
\alias{annotations<-,kwic,list-method}
\alias{annotations<-,textstat,list-method}
\alias{edit,textstat-method}
\title{Annotation functionality}
\usage{
annotations(x, ...)

\S4method{annotations}{kwic}(x, i, j, value)

\S4method{annotations}{textstat}(x, i, j, value)

annotations(x) <- value

\S4method{annotations}{kwic,list}(x) <- value

\S4method{annotations}{textstat,list}(x) <- value

\S4method{edit}{textstat}(name, viewer = shiny::paneViewer(minHeight = 550), ...)
}
\arguments{
\item{x}{An object to be annotated, a \code{kwic} class object, or an object
inheriting from the \code{textstat} class.}

\item{...}{Passed into \code{rhandsontable::rhandsontable}, can be used for
settings such as \code{height} etc.}

\item{i}{The row number (single \code{integer} value) of the
\code{data.table} where a new value shall be assigned.}

\item{j}{The column number (single \code{integer} value) of the
\code{data.table} where a new value shall be assigned.}

\item{value}{A value to assign.}

\item{name}{An S4 object to be annotated.}

\item{viewer}{The viewer to use, see \code{\link[shiny]{viewer}}.}
}
\value{
The modified input object is returned invisibly.
}
\description{
Objects that contain analytical results (\code{kwic} objects, objects
inheriting from the \code{textstat} class) can be annotated by creating an
annotation layer using the \code{annotations}-method. The augmented object
can be annotated using a shiny gadget by invoking the \code{edit}-method on
it. Note that operations are deliberately in-place, to prevent an unwanted
loss of work.
}
\details{
The \code{edit}-method is designed to be used in a RStudio session. It
generates a shiny gadget (see
\url{https://shiny.rstudio.com/articles/gadgets.html}) shown in the viewer
pane of RStudio.

The \code{edit}-method returns the modified input object. Note however that
changes of annotations are deliberately in-place operations: The input object
is changed even if you do not close the gadget "properly" by hitting the
"Done" button and catch the modified object. That may be forgotten easily and
would be painful after the work that may have been invested.

Consult the examples for the intended workflow.
}
\examples{
use(pkg = "RcppCWB", corpus = "REUTERS")

a <- 2
# upon initializing a kwic object, there is a minimal labels object
# in the labels slot of the kwic object, which we can get using the
# annotations-method
o <- kwic("REUTERS", query = "oil")
annotations(o) # see the result (a data.table)

# assign new annotations as follows, using the reference semantics of the
# data.table you get by calling the labels-method on an object 
annotations(o) <- list(name = "class", what = factor(x = "a", levels = c("a", "b", "c")))
annotations(o) <- list(name = "description", what = "")
annotations(o) # inspect the result

# assign values; note that is an in-place operation using the reference
# semantics of the data.table
# annotations(o, i = 77, j = 1, value = FALSE)
# annotations(o, i = 78, j = 1, value = FALSE)
annotations(o)

\dontrun{
edit(o)
annotations(o) # to see changes made

# maybe we want additional metadata
enrich(o, s_attributes = "places")
edit(o)
annotations(o)

# to get some extra context
o <- enrich(o, extra = 5L, table = TRUE)
edit(o)

# lineview may be better when you use a lot of extra context
options(polmineR.lineview = TRUE)
o <- kwic("REUTERS", "oil")
o <- enrich(o, extra = 20L)
edit(o)

x <- cooccurrences("REUTERS", query = "oil")
annotations(x) <- list(name = "keep", what = TRUE)
annotations(x) <- list(name = "category", what = factor("a", levels = letters[1:10]))
edit(x)
}
}
