% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bwd.R
\name{bw_rot_polysph}
\alias{bw_rot_polysph}
\title{Rule-of-thumb bandwidth selection for polyspherical kernel
density estimator}
\usage{
bw_rot_polysph(X, d, kernel = 1, kernel_type = c("prod", "sph")[1],
  bw0 = NULL, upscale = FALSE, deriv = 0, k = 10, kappa = NULL, ...)
}
\arguments{
\item{X}{a matrix of size \code{c(n, sum(d) + r)} with the sample.}

\item{d}{vector of size \code{r} with dimensions.}

\item{kernel}{kernel employed: \code{1} for von Mises--Fisher (default);
\code{2} for Epanechnikov; \code{3} for softplus.}

\item{kernel_type}{type of kernel employed: \code{1} for product kernel
(default); \code{2} for spherically symmetric kernel.}

\item{bw0}{initial bandwidth for minimizing the CV loss. If \code{NULL}, it
is computed internally by magnifying the \code{\link{bw_mrot_polysph}}
bandwidths by 50\%.}

\item{upscale}{rescale bandwidths to work on
\eqn{\mathcal{S}^{d_1}\times\cdots\times \mathcal{S}^{d_r}} and for
derivative estimation?
Defaults to \code{FALSE}. If \code{upscale = 1}, the order \code{n} is
upscaled. If \code{upscale = 2}, then also the kernel constant is upscaled.}

\item{deriv}{derivative order to perform the upscaling. Defaults to \code{0}.}

\item{k}{softplus kernel parameter. Defaults to \code{10.0}.}

\item{kappa}{estimate of the concentration parameters. Computed if not
provided (default).}

\item{...}{further arguments passed to \code{\link[stats]{nlm}}.}
}
\value{
A list with entries \code{bw} (optimal bandwidth) and \code{opt},
the latter containing the output of \code{\link[stats]{nlm}}.
}
\description{
Computes the rule-of-thumb bandwidth for the polyspherical
kernel density estimator using a product of von Mises--Fisher distributions
as reference in the Asymptotic Mean Integrated Squared Error (AMISE).
}
\details{
The selector assumes that the density curvature matrix
\eqn{\boldsymbol{R}} of the unknown density is approximable by that of a
product of von Mises--Fisher densities,
\eqn{\boldsymbol{R}(\boldsymbol{\kappa})}. The estimation of the
concentration parameters \eqn{\boldsymbol{\kappa}} is done by maximum
likelihood.
}
\examples{
n <- 100
d <- 1:2
kappa <- rep(10, 2)
X <- r_vmf_polysph(n = n, d = d, mu = r_unif_polysph(n = 1, d = d),
                   kappa = kappa)
bw_rot_polysph(X = X, d = d)$bw
}
