% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_graph.R
\name{policy_graph}
\alias{policy_graph}
\title{Extract the Policy Graph (as an igraph Object)}
\usage{
policy_graph(x, belief = TRUE, col = NULL)
}
\arguments{
\item{x}{A POMDP object.}

\item{belief}{logical; add belief proportions as a pie chart in each node of
the graph? If belief points are provided by the solver, then these are used.
If a number is specified, then a random sample of that size is used instead
to calculate belief proportions.}

\item{col}{colors used for the states in the belief proportions.}
}
\value{
An object of class igraph containing a directed graph.
}
\description{
Convert the policy graph in a POMDP solution object into an igraph object.
}
\examples{

data("Tiger")
sol <- solve_POMDP(model = Tiger)
sol

pg <- policy_graph(sol)

plot(pg)

}
\seealso{
\code{\link{solve_POMDP}}
}
\author{
Hossein Kamalzadeh, Michael Hahsler
}
\keyword{graphs}
