% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actions.R
\name{actions}
\alias{actions}
\title{Available Actions}
\usage{
actions(x, state)
}
\arguments{
\item{x}{a \code{MDP} pr \code{POMDP} object.}

\item{state}{a character vector of length one specifying the state.}
}
\value{
a character vector with the available actions.

a vector with the available actions.
}
\description{
Determine the set of actions available in a state.
}
\details{
Unavailable actions are modeled here a actions that have an immediate
reward of \code{-Inf} in the reward function.
}
\examples{
data(RussianTiger)

# The normal actions are "listen", "open-left", and "open-right".
# In the state "done" only the action "nothing" is available. 

actions(RussianTiger, state = "tiger-left")
actions(RussianTiger, state = "tiger-right")
actions(RussianTiger, state = "done")
}
\seealso{
Other MDP: 
\code{\link{MDP}()},
\code{\link{MDP2POMDP}},
\code{\link{MDP_policy_functions}},
\code{\link{accessors}},
\code{\link{add_policy}()},
\code{\link{gridworld}},
\code{\link{reachable_and_absorbing}},
\code{\link{regret}()},
\code{\link{simulate_MDP}()},
\code{\link{solve_MDP}()},
\code{\link{transition_graph}()},
\code{\link{value_function}()}

Other POMDP: 
\code{\link{MDP2POMDP}},
\code{\link{POMDP}()},
\code{\link{accessors}},
\code{\link{add_policy}()},
\code{\link{plot_belief_space}()},
\code{\link{projection}()},
\code{\link{reachable_and_absorbing}},
\code{\link{regret}()},
\code{\link{sample_belief_space}()},
\code{\link{simulate_POMDP}()},
\code{\link{solve_POMDP}()},
\code{\link{solve_SARSOP}()},
\code{\link{transition_graph}()},
\code{\link{update_belief}()},
\code{\link{value_function}()},
\code{\link{write_POMDP}()}
}
\author{
Michael Hahsler
}
\concept{MDP}
\concept{POMDP}
