% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reachable_and_absorbing.R
\name{reachable_and_absorbing}
\alias{reachable_and_absorbing}
\alias{reachable_states}
\alias{absorbing_states}
\alias{remove_unreachable_states}
\title{Reachable and Absorbing States}
\usage{
reachable_states(x, states = NULL)

absorbing_states(x, states = NULL)

remove_unreachable_states(x)
}
\arguments{
\item{x}{a \code{MDP} pr \code{POMDP} object.}

\item{states}{a character vector specifying the names of the states to be
checked. \code{NULL} checks all states.}
}
\value{
\code{reachable_states()} returns a logical vector indicating
if the states are reachable.

\code{absorbing_states()} returns a logical vector indicating
if the states are absorbing (terminal).

the model with all unreachable states removed
}
\description{
Find reachable and absorbing states in the transition model.
}
\details{
The function \code{reachable_states()} checks if states
are reachable using the transition model.

The function \code{absorbing_states()} checks if a state or a set of states are
absorbing (terminal states) with a zero reward (or \code{-Inf} for unavailable actions).
If no states are specified (\code{states = NULL}), then all model states are
checked. This information can be used in simulations to end an episode.

The function \code{remove_unreachable_states()} simplifies a model by
removing unreachable states.
}
\examples{
data(Maze)

gridworld_matrix(Maze, what = "label")

# the states marked with +1 and -1 are absorbing
absorbing_states(Maze)
which(absorbing_states(Maze))

# all states in the model are reachable
reachable_states(Maze)
which(!reachable_states(Maze))

}
\seealso{
Other MDP: 
\code{\link{MDP}()},
\code{\link{MDP2POMDP}},
\code{\link{MDP_policy_functions}},
\code{\link{accessors}},
\code{\link{actions}()},
\code{\link{add_policy}()},
\code{\link{gridworld}},
\code{\link{regret}()},
\code{\link{simulate_MDP}()},
\code{\link{solve_MDP}()},
\code{\link{transition_graph}()},
\code{\link{value_function}()}

Other POMDP: 
\code{\link{MDP2POMDP}},
\code{\link{POMDP}()},
\code{\link{accessors}},
\code{\link{actions}()},
\code{\link{add_policy}()},
\code{\link{plot_belief_space}()},
\code{\link{projection}()},
\code{\link{regret}()},
\code{\link{sample_belief_space}()},
\code{\link{simulate_POMDP}()},
\code{\link{solve_POMDP}()},
\code{\link{solve_SARSOP}()},
\code{\link{transition_graph}()},
\code{\link{update_belief}()},
\code{\link{value_function}()},
\code{\link{write_POMDP}()}
}
\author{
Michael Hahsler
}
\concept{MDP}
\concept{POMDP}
