% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI-connection.R
\docType{methods}
\name{DBI-connection}
\alias{DBI-connection}
\alias{dbSendQuery,Pool-method}
\alias{dbGetQuery,Pool,ANY-method}
\alias{dbExecute,Pool,ANY-method}
\alias{dbListResults,Pool-method}
\alias{dbListFields,Pool-method}
\alias{dbListTables,Pool-method}
\alias{dbReadTable,Pool,ANY-method}
\alias{dbWriteTable,Pool-method}
\alias{dbExistsTable,Pool-method}
\alias{dbRemoveTable,Pool-method}
\title{DBIConnection methods.}
\usage{
\S4method{dbSendQuery}{Pool}(conn, statement, ...)

\S4method{dbGetQuery}{Pool,ANY}(conn, statement, ...)

\S4method{dbExecute}{Pool,ANY}(conn, statement, ...)

\S4method{dbListResults}{Pool}(conn, ...)

\S4method{dbListFields}{Pool}(conn, name, ...)

\S4method{dbListTables}{Pool}(conn, ...)

\S4method{dbReadTable}{Pool,ANY}(conn, name, ...)

\S4method{dbWriteTable}{Pool}(conn, name, value, ...)

\S4method{dbExistsTable}{Pool}(conn, name, ...)

\S4method{dbRemoveTable}{Pool}(conn, name, ...)
}
\arguments{
\item{conn, statement, ...}{See \code{\link[DBI]{dbSendQuery}}.}

\item{name, value}{See \code{\link[DBI]{dbWriteTable}}.}
}
\description{
Pool object wrappers around DBIConnection methods. For the original
documentation, see:
\itemize{
 \item \code{\link[DBI]{dbSendQuery}}
 \item \code{\link[DBI]{dbGetQuery}}
 \item \code{\link[DBI]{dbListResults}}
 \item \code{\link[DBI]{dbListFields}}
 \item \code{\link[DBI]{dbListTables}}
 \item \code{\link[DBI]{dbReadTable}}
 \item \code{\link[DBI]{dbWriteTable}}
 \item \code{\link[DBI]{dbExistsTable}}
 \item \code{\link[DBI]{dbRemoveTable}}
}
}
