% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ABC.R
\name{index.rejABC}
\alias{index.rejABC}
\title{Parameter estimation with Approximate Bayesian Computation using rejection
sampling and recording just the index of accepted simulations}
\usage{
index.rejABC(target, params, sumstats, tol)
}
\arguments{
\item{target}{a vector with the target summary statistics. These are usually
the set of observed summary statistics.}

\item{params}{is a vector or matrix of simulated parameter values i.e.
numbers from the simulations. Each row or vector entry should be a
different simulation and each column of a matrix should be a different
parameter.}

\item{sumstats}{is a vector or matrix of simulated summary statistics. Each
row or vector entry should be a different simulation and each column of a
matrix should be a different statistic.}

\item{tol}{is the tolerance rate, indicating the required proportion of
points accepted nearest the target values.}
}
\value{
a list with two named entries

\item{index}{the index of the accepted simulations.}

\item{dst}{euclidean distances in the region of interest.}
}
\description{
This function performs multivariate parameter estimation based on summary
statistics using an Approximate Bayesian Computation (ABC) algorithm. The
algorithm used here is the rejection sampling algorithm. This is a simplified
version of the \code{\link[=rejABC]{rejABC()}} function that records only the index of the
accepted simulations.
}
\details{
The rejection sampling algorithm generates random samples from the posterior
distributions of the parameters of interest. Note that to use this function,
the usual steps of ABC parameter estimation have to be performed. Briefly,
data should have been simulated based on random draws from the prior
distributions of the parameters of interest and a set of summary statistics
should have been calculated from that data. The same set of summary
statistics should have been calculated from the observed data to be used as
the \code{target} input in this function. Parameter values are accepted if the
Euclidean distance between the set of summary statistics computed from the
simulated data and the set of summary statistics computed from the observed
data is sufficiently small. The percentage of accepted simulations is
determined by \code{tol}.
}
\examples{
# load the matrix with parameter values
data(params)
# load the matrix with simulated parameter values
data(sumstats)

# select a random simulation to act as target just to test the function
target <- sumstats[10 ,]

# Parameter estimation using rejection sampling
index.rejABC(target = target, params = params, sumstats = sumstats[-10, ], tol = 0.01)


}
