% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ABC.R
\name{mode_locfit}
\alias{mode_locfit}
\title{Compute mode of a locfit object}
\usage{
mode_locfit(locx, xlim, precision = 1000)
}
\arguments{
\item{locx}{is a locfit object.}

\item{xlim}{is a vector with two entries.The first entry is the minimum of
the distribution and the second entry is the maximum value of the
distribution.}

\item{precision}{value indicating the number of entries evaluated. The larger
the value the higher the precision. The default value is 1000.}
}
\value{
a numeric value of the mode of the input locfit object.
}
\description{
This function computes and outputs the the mode of a locfit object.
}
\details{
The \code{\link[stats:predict]{stats::predict()}} function is used to predict the y-axis values of the
locfit object and the mode is defined as the value where that prediction is
maximized.
}
\examples{
# create a random distribution
x <- rnorm(n = 1000, mean = 2, sd = 25)

# perform a local regression
loc <- locfit::locfit(~x)

# compute the mode of the locfit object
mode_locfit(locx = loc, xlim = c(min(x), max(x)))

}
