% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lognormal.R
\name{lognormal}
\alias{lognormal}
\title{Fit Lognormal Regression for Y vs. Covariates}
\usage{
lognormal(y, x = NULL, var = TRUE)
}
\arguments{
\item{y}{Numeric vector.}

\item{x}{Numeric vector or matrix. If \code{NULL}, model reduces to marginal
lognormal model Y ~ Lognormal(exp(beta_0), sigsq).}

\item{var}{Logical value for whether to return Hessian-based
variance-covariance matrix.}
}
\value{
List of parameter estimates, variance-covariance matrix (if
requested), AIC, and \code{\link[stats]{nlminb}} object.
}
\description{
Uses maximum likelihood to fit 
Y|\strong{X} ~ Lognormal(beta_0 + \strong{beta_x}^T \strong{X}, sigsq)
}
\examples{
# Generate data
set.seed(123)
x <- rnorm(1000)
y <- rlnorm(1000, meanlog = 0.5 + 0.25 * x, sdlog = 0.5)

# Fit model
fit <- lognormal(y = y, x = x)
fit$theta.hat
fit$varcov
fit$aic

# Plot E(Y) vs. X according to model fit
plot(x, y, main = "Lognormal Model for Y vs. X")
xvals <- seq(min(x), max(x), 0.01)
yvals <- exp(fit$theta.hat[1] + fit$theta.hat[2] * xvals + fit$theta.hat[3] / 2)
points(xvals, yvals, type = "l")


}
