% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{aq.census}
\alias{aq.census}
\title{Annual census data for Aquilegia chrysantha}
\format{A data frame with 2853 rows on the following 8 variables:
\describe{
  \item{plot}{Plot number}
  \item{year}{Year of census}
  \item{plant}{Plant id number}
  \item{status}{Plant status recorded in field: dead, dormant, recruit0
   (with cotyledons only), recruit1, flowering or vegetative. }
  \item{rose}{Total number of rosettes}
  \item{leaf}{Total number of leaves}
  \item{infl}{Total number of infloresences or flowering stalks}
  \item{fruits}{Total number of mature fruits}
}}
\source{
Data set owners: Brook Milligan, Chris Stubben, Allan Strand
}
\usage{
aq.census
}
\description{
Demography census data from \emph{Aquilegia chrysantha} in Fillmore Canyon,
Organ Mountains, New Mexico, 1996-2003.
}
\details{
This sample data set includes census data from 10 of the 15 total demography
plots established in 1995.
}
\examples{
head2(aq.census)
sv <- table(aq.census$status, aq.census$year)
sv
stage.vector.plot(sv[-1, ], prop = FALSE)
}
\seealso{
\code{\link{aq.trans}} for annual transitions with stage and fate
in same row
}
\keyword{datasets}
