% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CohenD.R
\name{CohenD}
\alias{CohenD}
\title{Calculate Cohen's cumulative distance}
\usage{
CohenD(A, vector)
}
\arguments{
\item{A}{a square, irreducible, non-negative numeric matrix of any dimension.}

\item{vector}{a numeric vector or one-column matrix describing the age/stage 
distribution used to calculate the distance.}
}
\value{
Cohen's D1.
}
\description{
Calculate Cohen's cumulative distance metric for a population matrix 
projection model.
}
\details{
Calculates the cumulative distance metric as outlined in Cohen (1979). 
Will not work for reducible matrices and returns a warning for imprimitive 
matrices (although will not function for imprimitive matrices with nonzero 
imaginary components in the dominant eigenpair).
}
\examples{
  # Create a 3x3 PPM
  ( A <- matrix(c(0,1,2,0.5,0.1,0,0,0.6,0.6), byrow=TRUE, ncol=3) )

  # Create an initial stage structure
  ( initial <- c(1,3,2) )

  # Calculate Cohen cumulative distance
  CohenD(A, vector=initial)

}
\references{
\itemize{
 \item Cohen (1979) SIAM J. Appl. Math., 36, 169-175.
 \item Stott et al. (2011) Ecol. Lett., 14, 959-970.
}
}
\seealso{
Other DistanceMeasures: \code{\link{KeyfitzD}},
  \code{\link{projectionD}}
}
\concept{
distance vector state space
}
