% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blockmatrix.R
\name{blockmatrix}
\alias{blockmatrix}
\title{Block-permute a reducible matrix}
\usage{
blockmatrix(A)
}
\arguments{
\item{A}{a square, reducible, non-negative numeric matrix of any dimension}
}
\value{
a list containing components:
\describe{
\item{\code{blockmatrix}}{ the block-permuted matrix. }
\item{\code{stage.order}}{ the permutation of rows/columns of \code{A} in the
block-permuted matrix. }
}
}
\description{
Conjugate a reducible matrix into block upper triangular form
}
\details{
Any square, reducible, non-negative matrix may have its rows and columns 
conjugated so that it takes a block upper triangular structure, with 
irreducible square submatrices on the diagonal, zero submatrices in the 
lower triangle and non-negative submatrices in the upper triangle (Caswell 
2001; Stott et al. 2010). \code{blockmatrix} permutes the rows and columns 
of a reducible matrix into this form, which enables further evaluation (e.g. 
computation of eigenvalues of submatrices).
}
\examples{
  # Create a 3x3 reducible PPM
  A <- matrix(c(0,1,0,0.5,0.1,0,0,0.6,0.6), byrow=TRUE, ncol=3)
  dimnames(A) <- list(c("Juv", "Pre-R", "R"), c("Juv", "Pre-R", "R"))
  A

  # Block-permute the matrix
  blockmatrix(A)

}
\references{
\itemize{
 \item Caswell (2001) Matrix population models 2nd ed. Sinauer.
 \item Stott et al. (2010) Methods. Ecol. Evol., 1, 242-252.
}
}
\concept{
reducible irreducible submatrix permutation conjugation permute conjugate 
arrange rearrange row column
}
