% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/season_function.R
\name{add_seasons}
\alias{add_seasons}
\alias{yearly}
\title{Add Seasons}
\usage{
add_seasons(data, level = "site", season_level = 2,
  date_column = "yearmon", summarize = NA, path = "~",
  download_if_missing = TRUE, clean = TRUE)

yearly(...)
}
\arguments{
\item{data}{data frame containing columns: date, period, newmoonnumber, or year and month}

\item{level}{"plot, "treatment" or "site"}

\item{season_level}{either year,
2: winter = Oct-March
   summer = April-Sept
4: winter = Dec-Feb
   spring = March-May
   summer = Jun-Aug
   fall = Sep-Nov}

\item{date_column}{either "date" (must be in format "y-m-d"), "period", "newmoonnumber",
or "yearmon" (data must contain "year" and "month")}

\item{summarize}{A function or list of functions specified by their name (e.g. "mean").
Default is NA (returned with seasons added but not summarized).}

\item{path}{path to location of downloaded Portal data; or "repo" to
retrieve data from github repo}

\item{download_if_missing}{if the specified file path doesn't have the
PortalData folder, then download it}

\item{clean}{logical, load only QA/QC rodent data (TRUE) or all data (FALSE)}

\item{...}{arguments passed to \code{\link{add_seasons}}}
}
\value{
a data.frame with additional "season" and "year" column, and other columns summarized as specified
}
\description{
Higher-order data summaries, by 6-month seasons, 3-month seasons, or year.
Also applies specified functions to the specified summary level.

\code{yearly} generates a table of yearly means
}
\examples{
\donttest{
yearly(abundance(path = "repo", time = "newmoon"),
       date_column = "newmoonnumber", path = "repo")
}
}
