#' portfolioBacktest: Automated Backtesting of Portfolios over Multiple Datasets
#'
#' Automated backtesting of multiple portfolios over multiple 
#' datasets of stock prices in a rolling-window fashion. Intended for 
#' researchers and practitioners to backtest a set of different portfolios, 
#' as well as by a course instructor to assess the students in their portfolio 
#' design in a fully automated and convenient manner, with results conveniently 
#' formatted in tables and plots. Each portfolio design is easily defined as a
#' function that takes as input a window of the stock prices and outputs the 
#' portfolio weights. Multiple portfolios can be easily specified as a list 
#' of functions or as files in a folder. Multiple datasets can be conveniently 
#' extracted randomly from different markets, different time periods, and 
#' different subsets of the stock universe. The results can be later assessed 
#' and ranked with tables based on a number of performance criteria (e.g., 
#' expected return, volatility, Sharpe ratio, drawdown, turnover rate, return 
#' on investment, computational time, etc.), as well as plotted in a number of 
#' ways with nice barplots and boxplots.
#' 
#' @section Functions:
#' \code{\link{stockDataDownload}}, \code{\link{stockDataResample}},
#' \code{\link{portfolioBacktest}}, \code{\link{backtestSelector}},
#' \code{\link{backtestTable}}, \code{\link{backtestBoxPlot}}, \code{\link{backtestLeaderboard}},
#' \code{\link{backtestSummary}}, \code{\link{summaryTable}}, \code{\link{summaryBarPlot}}
#'
#' @section Data:
#' \code{\link{dataset10}}, \code{\link{SP500_symbols}}
#'
#' @section Help:
#' For a quick help see the README file:
#' \href{https://github.com/dppalomar/portfolioBacktest/blob/master/README.md}{GitHub-README}.
#'
#' For more details see the vignette:
#' \href{https://CRAN.R-project.org/package=portfolioBacktest/vignettes/PortfolioBacktest.html}{CRAN-vignette}.
#'
#' @author Daniel P. Palomar and Rui ZHOU
#'
#' @docType package
#' @name portfolioBacktest-package
NULL
